/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.interop;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameUtil;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.FrameDescriptorProvider;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSConstantNode;
import com.oracle.truffle.js.nodes.access.JSReadFrameSlotNode;
import com.oracle.truffle.js.nodes.access.JSWriteFrameSlotNode;
import com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import com.oracle.truffle.js.nodes.access.WriteNode;
import com.oracle.truffle.js.nodes.function.BlockScopeNode;
import com.oracle.truffle.js.nodes.module.ReadImportBindingNode;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.interop.ScopeMembers;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.ArrayList;
import java.util.List;

@ExportLibrary(value=InteropLibrary.class)
public final class ScopeVariables
implements TruffleObject {
    public static final String RECEIVER_MEMBER = "this";
    static final int LIMIT = 4;
    final Frame frame;
    final boolean nodeEnter;
    final Node blockOrRoot;
    final Frame functionFrame;
    private ScopeMembers members;

    public ScopeVariables(Frame frame, boolean nodeEnter, Node blockOrRoot, Frame functionFrame) {
        this.frame = frame;
        this.nodeEnter = nodeEnter;
        this.blockOrRoot = blockOrRoot;
        this.functionFrame = functionFrame;
    }

    @ExportMessage
    boolean accepts(@Cached(value="this.blockOrRoot", adopt=false) Node cachedNode, @Cached(value="this.nodeEnter") boolean cachedNodeEnter) {
        return this.blockOrRoot == cachedNode && this.nodeEnter == cachedNodeEnter;
    }

    @ExportMessage
    boolean isScope() {
        return true;
    }

    @ExportMessage
    boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    Class<? extends TruffleLanguage<?>> getLanguage() {
        return JavaScriptLanguage.class;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean hasScopeParent() {
        if (this.blockOrRoot instanceof BlockScopeNode) {
            Node parentNode = JavaScriptNode.findBlockScopeNode(this.blockOrRoot.getParent());
            if (parentNode != null) {
                if (this.frame == null) {
                    return true;
                }
                if (this.getParentFrame(((BlockScopeNode)this.blockOrRoot).isFunctionBlock()) != null) {
                    return true;
                }
            }
        } else {
            assert (this.blockOrRoot instanceof RootNode);
            if (this.frame != null && ScopeFrameNode.isBlockScopeFrame(this.frame) && this.getParentFrame(false) != null) {
                return true;
            }
        }
        if (this.frame != null) {
            MaterializedFrame parentFrame = JSFrameUtil.getParentFrame(this.frame);
            return parentFrame != null && parentFrame != JSFrameUtil.NULL_MATERIALIZED_FRAME;
        }
        return false;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getScopeParent() throws UnsupportedMessageException {
        MaterializedFrame parentFrame;
        if (this.blockOrRoot instanceof BlockScopeNode) {
            Node parentBlock = JavaScriptNode.findBlockScopeNode(this.blockOrRoot.getParent());
            if (parentBlock != null) {
                if (this.frame == null) {
                    return new ScopeVariables(null, true, parentBlock, null);
                }
                Frame enclosingFrame = this.getParentFrame(((BlockScopeNode)this.blockOrRoot).isFunctionBlock());
                if (enclosingFrame != null) {
                    return new ScopeVariables(enclosingFrame, true, parentBlock, this.functionFrame);
                }
            }
        } else {
            Frame parentBlockScope;
            assert (this.blockOrRoot instanceof RootNode);
            if (this.frame != null && ScopeFrameNode.isBlockScopeFrame(this.frame) && (parentBlockScope = this.getParentFrame(false)) != null) {
                return new ScopeVariables(parentBlockScope, true, this.blockOrRoot, null);
            }
        }
        if (this.frame != null && (parentFrame = JSFrameUtil.getParentFrame(this.frame)) != null && parentFrame != JSFrameUtil.NULL_MATERIALIZED_FRAME) {
            RootNode rootNode = ((RootCallTarget)JSFunction.getCallTarget(JSFrameUtil.getFunctionObject(parentFrame))).getRootNode();
            return new ScopeVariables(parentFrame, true, rootNode, null);
        }
        throw UnsupportedMessageException.create();
    }

    @CompilerDirectives.TruffleBoundary
    private Frame getParentFrame(boolean functionBlock) {
        FrameSlot parentSlot = this.frame.getFrameDescriptor().findFrameSlot(ScopeFrameNode.PARENT_SCOPE_IDENTIFIER);
        if (parentSlot != null) {
            Object parent = FrameUtil.getObjectSafe(this.frame, parentSlot);
            if (parent instanceof Frame) {
                return (Frame)parent;
            }
            if (this.functionFrame != null && this.functionFrame != this.frame && !functionBlock) {
                return this.functionFrame;
            }
        }
        return null;
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getMembers(boolean includeInternal) {
        ScopeMembers m = this.members;
        if (m == null) {
            this.members = m = new ScopeMembers(this.frame, this.blockOrRoot, this.functionFrame);
        }
        return m;
    }

    @ExportMessage
    boolean isMemberInsertable(String member) {
        return false;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean hasSourceLocation() {
        return this.blockOrRoot.getEncapsulatingSourceSection() != null;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    SourceSection getSourceLocation() throws UnsupportedMessageException {
        SourceSection sourceLocation;
        Node sourceSectionProvider = this.blockOrRoot;
        if (sourceSectionProvider instanceof BlockScopeNode && ((BlockScopeNode)sourceSectionProvider).isFunctionBlock()) {
            sourceSectionProvider = sourceSectionProvider.getRootNode();
        }
        if ((sourceLocation = sourceSectionProvider.getEncapsulatingSourceSection()) == null) {
            throw UnsupportedMessageException.create();
        }
        return sourceLocation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object toDisplayString(boolean allowSideEffects) {
        RootNode root;
        if (this.blockOrRoot instanceof BlockScopeNode) {
            if (!((BlockScopeNode)this.blockOrRoot).isFunctionBlock()) return "block";
            root = this.blockOrRoot.getRootNode();
        } else {
            root = (RootNode)this.blockOrRoot;
        }
        String name = root.getName();
        if (name == null) {
            return "";
        }
        String string = name;
        return string;
    }

    static ResolvedSlot findSlot(String member, ScopeVariables receiver) {
        CompilerAsserts.neverPartOfCompilation();
        if (receiver.frame == null) {
            return ScopeVariables.findSlotWithoutFrame(member, receiver.blockOrRoot);
        }
        Node descNode = receiver.blockOrRoot;
        Frame outerFrame = receiver.frame;
        Frame currentFunctionFrame = receiver.functionFrame;
        int frameLevel = 0;
        while (true) {
            Frame outerScope = outerFrame;
            ArrayList<FrameSlot> parentSlotList = new ArrayList<FrameSlot>();
            int scopeLevel = 0;
            while (true) {
                FrameSlot parentSlot;
                FrameDescriptor frameDescriptor;
                FrameSlot slot;
                if ((slot = (frameDescriptor = outerScope.getFrameDescriptor()).findFrameSlot(member)) != null) {
                    if (JSFrameUtil.isInternal(slot)) {
                        return null;
                    }
                    if (JSFrameUtil.isImportBinding(slot)) {
                        return new ResolvedImportSlot(slot, frameLevel, scopeLevel, frameDescriptor, parentSlotList);
                    }
                    return new ResolvedSlot(slot, frameLevel, scopeLevel, frameDescriptor, parentSlotList);
                }
                FrameSlot evalScopeSlot = frameDescriptor.findFrameSlot("<evalscope>");
                if (evalScopeSlot != null) {
                    DynamicObject evalScope = (DynamicObject)FrameUtil.getObjectSafe(outerScope, evalScopeSlot);
                    DynamicObjectLibrary objLib = DynamicObjectLibrary.getUncached();
                    if (objLib.containsKey(evalScope, member)) {
                        return new DynamicScopeResolvedSlot(member, evalScopeSlot, frameLevel, scopeLevel, frameDescriptor, parentSlotList);
                    }
                }
                if ((parentSlot = frameDescriptor.findFrameSlot(ScopeFrameNode.PARENT_SCOPE_IDENTIFIER)) == null) break;
                assert (scopeLevel >= 0);
                Object parent = FrameUtil.getObjectSafe(outerScope, parentSlot);
                if (parent instanceof Frame) {
                    outerScope = (Frame)parent;
                    parentSlotList.add(parentSlot);
                    ++scopeLevel;
                } else {
                    if (currentFunctionFrame == null || currentFunctionFrame == outerScope) break;
                    outerScope = currentFunctionFrame;
                    scopeLevel = -1;
                }
                if (descNode == null) continue;
                descNode = JavaScriptNode.findBlockScopeNode(descNode.getParent());
            }
            outerFrame = JSArguments.getEnclosingFrame(outerFrame.getArguments());
            currentFunctionFrame = null;
            if (outerFrame == JSFrameUtil.NULL_MATERIALIZED_FRAME) break;
            ++frameLevel;
        }
        return null;
    }

    private static ResolvedSlot findSlotWithoutFrame(String member, Node blockOrRootNode) {
        Node descNode = blockOrRootNode;
        while (descNode != null && descNode instanceof FrameDescriptorProvider) {
            FrameDescriptor desc = ((FrameDescriptorProvider)((Object)descNode)).getFrameDescriptor();
            FrameSlot slot = desc.findFrameSlot(member);
            if (slot != null) {
                if (JSFrameUtil.isInternal(slot)) {
                    return null;
                }
                return new ResolvedSlot();
            }
            descNode = JavaScriptNode.findBlockScopeNode(descNode.getParent());
        }
        return null;
    }

    static boolean hasSlot(String member, ScopeVariables receiver) {
        return ScopeVariables.findSlot(member, receiver) != null;
    }

    static JavaScriptNode findReadNode(ResolvedSlot slot) {
        if (slot != null) {
            return slot.createReadNode();
        }
        return null;
    }

    static WriteNode findWriteNode(ResolvedSlot slot) {
        if (slot != null && slot.isModifiable()) {
            return slot.createWriteNode();
        }
        return null;
    }

    static Object getThis(Frame frame) {
        Object[] args;
        Object function;
        FrameSlot thisSlot = JSFrameUtil.getThisSlot(frame.getFrameDescriptor());
        if (thisSlot == null) {
            return ScopeVariables.thisFromArguments(frame.getArguments());
        }
        Object thiz = frame.getValue(thisSlot);
        if (thiz == Undefined.instance && JSFunction.isJSFunction(function = JSArguments.getFunctionObject(args = frame.getArguments()))) {
            DynamicObject jsFunction = (DynamicObject)function;
            thiz = ScopeVariables.isArrowFunctionWithThisCaptured(jsFunction) ? JSFunction.getLexicalThis(jsFunction) : ScopeVariables.thisFromArguments(args);
        }
        return thiz;
    }

    private static Object thisFromArguments(Object[] args) {
        Object thisObject = JSArguments.getThisObject(args);
        Object function = JSArguments.getFunctionObject(args);
        if (JSFunction.isJSFunction(function) && !JSFunction.isStrict((DynamicObject)function)) {
            JSRealm realm = JavaScriptLanguage.getCurrentJSRealm();
            thisObject = thisObject == Undefined.instance || thisObject == Null.instance ? realm.getGlobalObject() : JSRuntime.toObject(realm.getContext(), thisObject);
        }
        return thisObject;
    }

    private static boolean isArrowFunctionWithThisCaptured(DynamicObject function) {
        return !JSFunction.isConstructor(function) && JSFunction.isClassPrototypeInitialized(function);
    }

    static class ResolvedImportSlot
    extends ResolvedSlot {
        ResolvedImportSlot(FrameSlot slot, int frameLevel, int scopeLevel, FrameDescriptor descriptor, List<FrameSlot> parentSlotList) {
            super(slot, frameLevel, scopeLevel, descriptor, parentSlotList);
        }

        @Override
        JavaScriptNode createReadNode() {
            if (!this.hasSlot()) {
                return JSConstantNode.createUndefined();
            }
            return ReadImportBindingNode.create(super.createReadNode());
        }
    }

    static class DynamicScopeResolvedSlot
    extends ResolvedSlot {
        final Object key;

        DynamicScopeResolvedSlot(Object key, FrameSlot slot, int frameLevel, int scopeLevel, FrameDescriptor descriptor, List<FrameSlot> parentSlotList) {
            super(slot, frameLevel, scopeLevel, descriptor, parentSlotList);
            this.key = key;
        }

        @Override
        JavaScriptNode createReadNode() {
            final JavaScriptNode readDynamicScope = super.createReadNode();
            class EvalRead
            extends JavaScriptNode {
                @Node.Child
                JavaScriptNode getDynamicScope;
                @Node.Child
                DynamicObjectLibrary objectLibrary;

                EvalRead() {
                    this.getDynamicScope = readDynamicScope;
                }

                @Override
                public Object execute(VirtualFrame frame) {
                    DynamicObject scope = (DynamicObject)this.getDynamicScope.execute(frame);
                    DynamicObjectLibrary lib = this.objectLibrary;
                    if (lib == null) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        lib = this.getParent() != null ? this.insert(DynamicObjectLibrary.getFactory().createDispatched(5)) : DynamicObjectLibrary.getUncached();
                        this.objectLibrary = lib;
                    }
                    return lib.getOrDefault(scope, DynamicScopeResolvedSlot.this.key, Undefined.instance);
                }
            }
            return new EvalRead();
        }

        @Override
        WriteNode createWriteNode() {
            final JavaScriptNode readDynamicScope = super.createReadNode();
            class EvalWrite
            extends JavaScriptNode
            implements WriteNode {
                @Node.Child
                JavaScriptNode getDynamicScope;
                @Node.Child
                DynamicObjectLibrary objectLibrary;

                EvalWrite() {
                    this.getDynamicScope = readDynamicScope;
                }

                @Override
                public Object execute(VirtualFrame frame) {
                    throw CompilerDirectives.shouldNotReachHere();
                }

                @Override
                public Object executeWrite(VirtualFrame frame, Object value) {
                    DynamicObject scope = (DynamicObject)this.getDynamicScope.execute(frame);
                    DynamicObjectLibrary lib = this.objectLibrary;
                    if (lib == null) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        lib = this.getParent() != null ? this.insert(DynamicObjectLibrary.getFactory().createDispatched(5)) : DynamicObjectLibrary.getUncached();
                        this.objectLibrary = lib;
                    }
                    return lib.putIfPresent(scope, DynamicScopeResolvedSlot.this.key, value);
                }

                @Override
                public JavaScriptNode getRhs() {
                    return null;
                }
            }
            return new EvalWrite();
        }
    }

    static class ResolvedSlot {
        final FrameSlot slot;
        final int frameLevel;
        final int scopeLevel;
        final FrameDescriptor descriptor;
        final FrameSlot[] parentSlots;

        ResolvedSlot(FrameSlot slot, int frameLevel, int scopeLevel, FrameDescriptor descriptor, List<FrameSlot> parentSlotList) {
            this.slot = slot;
            this.frameLevel = frameLevel;
            this.scopeLevel = scopeLevel;
            this.descriptor = descriptor;
            this.parentSlots = parentSlotList == null ? null : parentSlotList.toArray(ScopeFrameNode.EMPTY_FRAME_SLOT_ARRAY);
        }

        ResolvedSlot() {
            this(null, -1, -1, null, null);
        }

        JavaScriptNode createReadNode() {
            if (this.slot == null) {
                return JSConstantNode.createUndefined();
            }
            ScopeFrameNode scopeFrameNode = this.createScopeFrameNode();
            return JSReadFrameSlotNode.create(this.slot, scopeFrameNode, JSFrameUtil.hasTemporalDeadZone(this.slot));
        }

        WriteNode createWriteNode() {
            if (this.slot == null) {
                return null;
            }
            ScopeFrameNode scopeFrameNode = this.createScopeFrameNode();
            return JSWriteFrameSlotNode.create(this.slot, scopeFrameNode, null, this.descriptor, JSFrameUtil.hasTemporalDeadZone(this.slot));
        }

        ScopeFrameNode createScopeFrameNode() {
            if (this.isFunctionFrame()) {
                return ScopeFrameNode.createCurrent();
            }
            return ScopeFrameNode.create(this.frameLevel, this.scopeLevel, this.parentSlots, null);
        }

        boolean isModifiable() {
            return this.hasSlot() && !JSFrameUtil.isConst(this.slot) && !JSFrameUtil.isThisSlot(this.slot) && !JSFrameUtil.isImportBinding(this.slot);
        }

        boolean hasSlot() {
            return this.slot != null;
        }

        boolean isFunctionFrame() {
            return this.scopeLevel < 0;
        }

        public String toString() {
            if (this.hasSlot()) {
                return this.getClass().getSimpleName() + "(" + this.slot + ", " + this.frameLevel + "/" + this.scopeLevel + ")";
            }
            return super.toString();
        }
    }

    @ExportMessage
    static final class WriteMember {
        WriteMember() {
        }

        @Specialization(guards={"RECEIVER_MEMBER.equals(member)"})
        @CompilerDirectives.TruffleBoundary
        static void doWriteThis(ScopeVariables receiver, String member, Object value) throws UnknownIdentifierException {
            throw UnknownIdentifierException.create(member);
        }

        @Specialization(guards={"cachedMember.equals(member)", "!RECEIVER_MEMBER.equals(cachedMember)"}, limit="LIMIT")
        static void doCached(ScopeVariables receiver, String member, Object value, @Cached(value="member") String cachedMember, @Cached(value="findSlot(member, receiver)") ResolvedSlot resolvedSlot, @Cached(value="findWriteNode(resolvedSlot)") WriteNode writeNode) throws UnknownIdentifierException {
            WriteMember.doWrite(receiver, cachedMember, value, writeNode, resolvedSlot);
        }

        @Specialization(guards={"!RECEIVER_MEMBER.equals(member)"}, replaces={"doCached"})
        @CompilerDirectives.TruffleBoundary
        static void doGeneric(ScopeVariables receiver, String member, Object value) throws UnknownIdentifierException {
            ResolvedSlot resolvedSlot = ScopeVariables.findSlot(member, receiver);
            WriteNode writeNode = ScopeVariables.findWriteNode(resolvedSlot);
            WriteMember.doWrite(receiver, member, value, writeNode, resolvedSlot);
        }

        private static void doWrite(ScopeVariables receiver, String member, Object value, WriteNode writeNode, ResolvedSlot resolvedSlot) throws UnknownIdentifierException {
            Frame frame;
            if (writeNode == null) {
                throw UnknownIdentifierException.create(member);
            }
            Frame frame2 = frame = resolvedSlot.isFunctionFrame() ? receiver.functionFrame : receiver.frame;
            if (frame == null) {
                throw UnknownIdentifierException.create(member);
            }
            writeNode.executeWrite((VirtualFrame)frame, value);
        }
    }

    @ExportMessage
    static final class ReadMember {
        ReadMember() {
        }

        @Specialization(guards={"RECEIVER_MEMBER.equals(member)"})
        @CompilerDirectives.TruffleBoundary
        static Object doReadThis(ScopeVariables receiver, String member) throws UnknownIdentifierException {
            if (receiver.frame != null) {
                return ScopeVariables.getThis(receiver.frame);
            }
            throw UnknownIdentifierException.create(member);
        }

        @Specialization(guards={"cachedMember.equals(member)", "!RECEIVER_MEMBER.equals(cachedMember)"}, limit="LIMIT")
        static Object doCached(ScopeVariables receiver, String member, @Cached(value="member") String cachedMember, @Cached(value="findSlot(member, receiver)") ResolvedSlot resolvedSlot, @Cached(value="findReadNode(resolvedSlot)") JavaScriptNode readNode) throws UnknownIdentifierException {
            return ReadMember.doRead(receiver, cachedMember, readNode, resolvedSlot);
        }

        @Specialization(guards={"!RECEIVER_MEMBER.equals(member)"}, replaces={"doCached"})
        @CompilerDirectives.TruffleBoundary
        static Object doGeneric(ScopeVariables receiver, String member) throws UnknownIdentifierException {
            ResolvedSlot resolvedSlot = ScopeVariables.findSlot(member, receiver);
            JavaScriptNode readNode = ScopeVariables.findReadNode(resolvedSlot);
            return ReadMember.doRead(receiver, member, readNode, resolvedSlot);
        }

        private static Object doRead(ScopeVariables receiver, String member, JavaScriptNode readNode, ResolvedSlot resolvedSlot) throws UnknownIdentifierException {
            Frame frame;
            if (readNode == null) {
                throw UnknownIdentifierException.create(member);
            }
            Frame frame2 = frame = resolvedSlot.isFunctionFrame() ? receiver.functionFrame : receiver.frame;
            if (frame == null) {
                return Undefined.instance;
            }
            return readNode.execute((VirtualFrame)frame);
        }
    }

    @ExportMessage
    static final class IsMemberModifiable {
        IsMemberModifiable() {
        }

        @Specialization(guards={"RECEIVER_MEMBER.equals(member)"})
        static boolean doReadThis(ScopeVariables receiver, String member) {
            return receiver.frame != null;
        }

        @Specialization(guards={"cachedMember.equals(member)", "!RECEIVER_MEMBER.equals(cachedMember)"}, limit="LIMIT")
        static boolean doCached(ScopeVariables receiver, String member, @Cached(value="member") String cachedMember, @Cached(value="doGeneric(receiver, member)") boolean cachedResult) {
            assert (cachedResult == IsMemberModifiable.doGeneric(receiver, member));
            return cachedResult;
        }

        @Specialization(guards={"!RECEIVER_MEMBER.equals(member)"}, replaces={"doCached"})
        @CompilerDirectives.TruffleBoundary
        static boolean doGeneric(ScopeVariables receiver, String member) {
            ResolvedSlot slot = ScopeVariables.findSlot(member, receiver);
            return slot != null && slot.isModifiable();
        }
    }

    @ExportMessage
    static final class IsMemberReadable {
        IsMemberReadable() {
        }

        @Specialization(guards={"RECEIVER_MEMBER.equals(member)"})
        static boolean doReadThis(ScopeVariables receiver, String member) {
            return receiver.frame != null;
        }

        @Specialization(guards={"cachedMember.equals(member)", "!RECEIVER_MEMBER.equals(cachedMember)"}, limit="LIMIT")
        static boolean doCached(ScopeVariables receiver, String member, @Cached(value="member") String cachedMember, @Cached(value="doGeneric(receiver, member)") boolean cachedResult) {
            assert (cachedResult == IsMemberReadable.doGeneric(receiver, member));
            return cachedResult;
        }

        @Specialization(guards={"!RECEIVER_MEMBER.equals(member)"}, replaces={"doCached"})
        @CompilerDirectives.TruffleBoundary
        static boolean doGeneric(ScopeVariables receiver, String member) {
            return ScopeVariables.hasSlot(member, receiver);
        }
    }
}

