/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.util;

import com.oracle.truffle.api.nodes.NodeCloneable;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;

public final class StringBuilderProfile
extends NodeCloneable {
    private static final int MAX_INT_STRING_LENGTH = 11;
    private static final int MAX_LONG_STRING_LENGTH = 20;
    private final int stringLengthLimit;
    private final BranchProfile errorBranch;

    private StringBuilderProfile(int stringLengthLimit) {
        this.stringLengthLimit = stringLengthLimit;
        this.errorBranch = BranchProfile.create();
    }

    public static StringBuilderProfile create(int stringLengthLimit) {
        return new StringBuilderProfile(stringLengthLimit);
    }

    public StringBuilder newStringBuilder() {
        return new StringBuilder();
    }

    public StringBuilder newStringBuilder(int capacity) {
        return new StringBuilder(Math.max(16, Math.min(capacity, this.stringLengthLimit)));
    }

    public String toString(StringBuilder builder) {
        return Boundaries.builderToString(builder);
    }

    public void append(StringBuilder builder, String str) {
        if (builder.length() + str.length() > this.stringLengthLimit) {
            this.errorBranch.enter();
            throw Errors.createRangeErrorInvalidStringLength();
        }
        Boundaries.builderAppend(builder, str);
    }

    public void append(StringBuilder builder, char c) {
        if (builder.length() + 1 > this.stringLengthLimit) {
            this.errorBranch.enter();
            throw Errors.createRangeErrorInvalidStringLength();
        }
        Boundaries.builderAppend(builder, c);
    }

    public void append(StringBuilder builder, int intValue) {
        if (builder.length() + 11 > this.stringLengthLimit) {
            this.errorBranch.enter();
            throw Errors.createRangeErrorInvalidStringLength();
        }
        Boundaries.builderAppend(builder, intValue);
    }

    public void append(StringBuilder builder, long longValue) {
        if (builder.length() + 20 > this.stringLengthLimit) {
            this.errorBranch.enter();
            throw Errors.createRangeErrorInvalidStringLength();
        }
        Boundaries.builderAppend(builder, longValue);
    }

    public void append(StringBuilder builder, String charSequence, int start, int end) {
        assert (start <= end);
        if (builder.length() + (end - start) > this.stringLengthLimit) {
            this.errorBranch.enter();
            throw Errors.createRangeErrorInvalidStringLength();
        }
        Boundaries.builderAppend(builder, charSequence, start, end);
    }

    @Override
    protected Object clone() {
        return new StringBuilderProfile(this.stringLengthLimit);
    }
}

