/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.regex.RegexBodyNode;
import com.oracle.truffle.regex.RegexLanguage;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.result.RegexResult;
import com.oracle.truffle.regex.tregex.nodes.input.InputLengthNode;
import com.oracle.truffle.regex.tregex.nodes.input.InputReadNode;

public abstract class RegexExecNode
extends RegexBodyNode {
    private final boolean mustCheckUnicodeSurrogates;
    @Node.Child
    private InputLengthNode lengthNode;
    @Node.Child
    private InputReadNode charAtNode;

    public RegexExecNode(RegexLanguage language, RegexSource source, boolean mustCheckUnicodeSurrogates) {
        super(language, source);
        this.mustCheckUnicodeSurrogates = mustCheckUnicodeSurrogates;
    }

    @Override
    public final RegexResult execute(VirtualFrame frame) {
        Object[] args = frame.getArguments();
        assert (args.length == 2);
        return this.executeDirect(args[0], (Integer)args[1]);
    }

    private int adjustFromIndex(int fromIndex, Object input) {
        if (this.mustCheckUnicodeSurrogates && fromIndex > 0 && fromIndex < this.inputLength(input) && Character.isLowSurrogate((char)this.inputRead(input, fromIndex)) && Character.isHighSurrogate((char)this.inputRead(input, fromIndex - 1))) {
            return fromIndex - 1;
        }
        return fromIndex;
    }

    public int inputLength(Object input) {
        if (this.lengthNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.lengthNode = this.insert(InputLengthNode.create());
        }
        return this.lengthNode.execute(input);
    }

    public int inputRead(Object input, int i) {
        if (this.charAtNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.charAtNode = this.insert(InputReadNode.create());
        }
        return this.charAtNode.execute(input, i);
    }

    public RegexResult executeDirect(Object input, int fromIndex) {
        if (fromIndex < 0 || fromIndex > this.inputLength(input)) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException(String.format("got illegal fromIndex value: %d. fromIndex must be >= 0 and <= input length (%d)", fromIndex, this.inputLength(input)));
        }
        return this.execute(input, this.adjustFromIndex(fromIndex, input));
    }

    public boolean isBacktracking() {
        return false;
    }

    protected abstract RegexResult execute(Object var1, int var2);
}

