/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.result;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.regex.AbstractConstantKeysObject;
import com.oracle.truffle.regex.AbstractRegexObject;
import com.oracle.truffle.regex.result.RegexResultFactory;
import com.oracle.truffle.regex.runtime.nodes.DispatchNode;
import com.oracle.truffle.regex.runtime.nodes.ToIntNode;
import com.oracle.truffle.regex.util.TruffleReadOnlyKeysArray;
import java.util.Arrays;

@ExportLibrary(value=InteropLibrary.class)
public final class RegexResult
extends AbstractConstantKeysObject {
    static final String PROP_IS_MATCH = "isMatch";
    static final String PROP_GET_START = "getStart";
    static final String PROP_GET_END = "getEnd";
    private static final TruffleReadOnlyKeysArray KEYS = new TruffleReadOnlyKeysArray("isMatch", "getStart", "getEnd");
    private final Object input;
    private final int fromIndex;
    private final int start;
    private final int end;
    private int[] indices;
    private final CallTarget lazyCallTarget;
    private static final RegexResult NO_MATCH_RESULT = new RegexResult(null, -1, -1, -1, new int[0], null);
    private static final int INVALID_RESULT_INDEX = -1;

    protected RegexResult(Object input, int fromIndex, int start, int end, int[] indices, CallTarget lazyCallTarget) {
        this.input = input;
        this.fromIndex = fromIndex;
        this.start = start;
        this.end = end;
        this.indices = indices;
        this.lazyCallTarget = lazyCallTarget;
    }

    public static RegexResult getNoMatchInstance() {
        return NO_MATCH_RESULT;
    }

    public static RegexResult create(int start, int end) {
        return new RegexResult(null, -1, 0, 0, new int[]{start, end}, null);
    }

    public static RegexResult create(int[] indices) {
        assert (indices != null && indices.length >= 2);
        return new RegexResult(null, -1, 0, 0, indices, null);
    }

    public static RegexResult create(Object input, int[] indices) {
        assert (indices != null && indices.length >= 2);
        return new RegexResult(input, -1, 0, 0, indices, null);
    }

    public static RegexResult createLazy(Object input, int fromIndex, int start, int end, CallTarget lazyCallTarget) {
        return new RegexResult(input, fromIndex, start, end, null, lazyCallTarget);
    }

    public Object getInput() {
        return this.input;
    }

    public int getFromIndex() {
        return this.fromIndex;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setIndices(int[] indices) {
        this.indices = indices;
    }

    public int getStart(int groupNumber) {
        int index = groupNumber * 2;
        return index >= this.indices.length ? -1 : this.indices[index];
    }

    public int getEnd(int groupNumber) {
        int index = groupNumber * 2 + 1;
        return index >= this.indices.length ? -1 : this.indices[index];
    }

    @Override
    @ExportMessage
    public Object getMembers(boolean includeInternal) {
        return KEYS;
    }

    @Override
    public TruffleReadOnlyKeysArray getKeys() {
        return KEYS;
    }

    @Override
    public Object readMemberImpl(String symbol) throws UnknownIdentifierException {
        switch (symbol) {
            case "isMatch": {
                return this != RegexResult.getNoMatchInstance();
            }
            case "getStart": {
                return new RegexResultGetStartMethod(this);
            }
            case "getEnd": {
                return new RegexResultGetEndMethod(this);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw UnknownIdentifierException.create(symbol);
    }

    @ExportMessage
    Object invokeMember(String member, Object[] args, @Cached ToIntNode toIntNode, @Cached InvokeCacheNode invokeCache) throws UnknownIdentifierException, ArityException, UnsupportedTypeException {
        if (args.length != 1) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw ArityException.create(1, 1, args.length);
        }
        return invokeCache.execute(this, member, toIntNode.execute(args[0]));
    }

    @CompilerDirectives.TruffleBoundary
    public void debugForceEvaluation() {
        CompilerAsserts.neverPartOfCompilation();
        assert (this != RegexResult.getNoMatchInstance());
        if (this.indices == null) {
            this.lazyCallTarget.call(this);
        }
        assert (this.indices != null);
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        if (this == RegexResult.getNoMatchInstance()) {
            return "NO_MATCH";
        }
        if (this.indices == null) {
            return "[ _lazy_ ]";
        }
        return Arrays.toString(this.indices);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    public Object toDisplayString(boolean allowSideEffects) {
        if (allowSideEffects) {
            this.debugForceEvaluation();
            return "TRegexResult" + this;
        }
        return "TRegexResult";
    }

    @GenerateUncached
    public static abstract class RegexResultGetStartNode
    extends Node {
        public static RegexResultGetStartNode create() {
            return RegexResultFactory.RegexResultGetStartNodeGen.create();
        }

        public abstract int execute(Object var1, int var2);

        @Specialization
        static int doResult(RegexResult receiver, int groupNumber, @Cached ConditionProfile lazyProfile, @Cached DispatchNode getIndicesCall) {
            int i;
            if (lazyProfile.profile(receiver.indices == null)) {
                assert (receiver.lazyCallTarget != null);
                getIndicesCall.execute(receiver.lazyCallTarget, receiver);
            }
            return (i = groupNumber * 2) < 0 || i >= receiver.indices.length ? -1 : receiver.indices[i];
        }
    }

    @GenerateUncached
    static abstract class RegexResultGetEndNode
    extends Node {
        RegexResultGetEndNode() {
        }

        abstract int execute(Object var1, int var2);

        @Specialization
        static int doResult(RegexResult receiver, int groupNumber, @Cached ConditionProfile lazyProfile, @Cached DispatchNode getIndicesCall) {
            int i;
            if (lazyProfile.profile(receiver.indices == null)) {
                assert (receiver.lazyCallTarget != null);
                getIndicesCall.execute(receiver.lazyCallTarget, receiver);
            }
            return (i = groupNumber * 2 + 1) < 0 || i >= receiver.indices.length ? -1 : receiver.indices[i];
        }
    }

    @ImportStatic(value={RegexResult.class})
    @GenerateUncached
    static abstract class InvokeCacheNode
    extends Node {
        InvokeCacheNode() {
        }

        abstract Object execute(RegexResult var1, String var2, int var3) throws UnknownIdentifierException;

        @Specialization(guards={"symbol == cachedSymbol", "cachedSymbol.equals(PROP_GET_START)"}, limit="2")
        Object getStartIdentity(RegexResult receiver, String symbol, int groupNumber, @Cached(value="symbol") String cachedSymbol, @Cached RegexResultGetStartNode getStartNode) {
            return getStartNode.execute(receiver, groupNumber);
        }

        @Specialization(guards={"symbol.equals(cachedSymbol)", "cachedSymbol.equals(PROP_GET_START)"}, limit="2", replaces={"getStartIdentity"})
        Object getStartEquals(RegexResult receiver, String symbol, int groupNumber, @Cached(value="symbol") String cachedSymbol, @Cached RegexResultGetStartNode getStartNode) {
            return getStartNode.execute(receiver, groupNumber);
        }

        @Specialization(guards={"symbol == cachedSymbol", "cachedSymbol.equals(PROP_GET_END)"}, limit="2")
        Object getEndIdentity(RegexResult receiver, String symbol, int groupNumber, @Cached(value="symbol") String cachedSymbol, @Cached RegexResultGetEndNode getEndNode) {
            return getEndNode.execute(receiver, groupNumber);
        }

        @Specialization(guards={"symbol.equals(cachedSymbol)", "cachedSymbol.equals(PROP_GET_END)"}, limit="2", replaces={"getEndIdentity"})
        Object getEndEquals(RegexResult receiver, String symbol, int groupNumber, @Cached(value="symbol") String cachedSymbol, @Cached RegexResultGetEndNode getEndNode) {
            return getEndNode.execute(receiver, groupNumber);
        }

        @Specialization(replaces={"getStartEquals", "getEndEquals"})
        @ReportPolymorphism.Megamorphic
        static Object invokeGeneric(RegexResult receiver, String symbol, int groupNumber, @Cached RegexResultGetStartNode getStartNode, @Cached RegexResultGetEndNode getEndNode) throws UnknownIdentifierException {
            switch (symbol) {
                case "getStart": {
                    return getStartNode.execute(receiver, groupNumber);
                }
                case "getEnd": {
                    return getEndNode.execute(receiver, groupNumber);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw UnknownIdentifierException.create(symbol);
        }
    }

    @ExportMessage
    static abstract class IsMemberInvocable {
        IsMemberInvocable() {
        }

        @Specialization(guards={"symbol == cachedSymbol", "result"}, limit="2")
        static boolean cacheIdentity(RegexResult receiver, String symbol, @Cached(value="symbol") String cachedSymbol, @Cached(value="isInvocable(receiver, cachedSymbol)") boolean result) {
            return result;
        }

        @Specialization(guards={"symbol.equals(cachedSymbol)", "result"}, limit="2", replaces={"cacheIdentity"})
        static boolean cacheEquals(RegexResult receiver, String symbol, @Cached(value="symbol") String cachedSymbol, @Cached(value="isInvocable(receiver, cachedSymbol)") boolean result) {
            return result;
        }

        @Specialization(replaces={"cacheEquals"})
        static boolean isInvocable(RegexResult receiver, String symbol) {
            return RegexResult.PROP_GET_START.equals(symbol) || RegexResult.PROP_GET_END.equals(symbol);
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class RegexResultGetEndMethod
    extends AbstractRegexObject {
        private final RegexResult result;

        RegexResultGetEndMethod(RegexResult result) {
            this.result = result;
        }

        @ExportMessage
        boolean isExecutable() {
            return true;
        }

        @ExportMessage
        int execute(Object[] args, @Cached ToIntNode toIntNode, @Cached RegexResultGetEndNode getEndNode) throws ArityException, UnsupportedTypeException {
            if (args.length != 1) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw ArityException.create(1, 1, args.length);
            }
            return getEndNode.execute(this.result, toIntNode.execute(args[0]));
        }

        @CompilerDirectives.TruffleBoundary
        public String toString() {
            return "TRegexResultGetEndMethod{result=" + this.result + '}';
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class RegexResultGetStartMethod
    extends AbstractRegexObject {
        private final RegexResult result;

        RegexResultGetStartMethod(RegexResult result) {
            this.result = result;
        }

        @ExportMessage
        boolean isExecutable() {
            return true;
        }

        @ExportMessage
        int execute(Object[] args, @Cached ToIntNode toIntNode, @Cached RegexResultGetStartNode getStartNode) throws ArityException, UnsupportedTypeException {
            if (args.length != 1) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw ArityException.create(1, 1, args.length);
            }
            return getStartNode.execute(this.result, toIntNode.execute(args[0]));
        }

        @CompilerDirectives.TruffleBoundary
        public String toString() {
            return "TRegexResultGetStartMethod{result=" + this.result + '}';
        }
    }

    @ExportMessage
    static abstract class IsMemberReadable {
        IsMemberReadable() {
        }

        @Specialization(guards={"symbol == cachedSymbol", "result"}, limit="3")
        static boolean cacheIdentity(RegexResult receiver, String symbol, @Cached(value="symbol") String cachedSymbol, @Cached(value="isReadable(receiver, cachedSymbol)") boolean result) {
            return result;
        }

        @Specialization(guards={"symbol.equals(cachedSymbol)", "result"}, limit="3", replaces={"cacheIdentity"})
        static boolean cacheEquals(RegexResult receiver, String symbol, @Cached(value="symbol") String cachedSymbol, @Cached(value="isReadable(receiver, cachedSymbol)") boolean result) {
            return result;
        }

        @Specialization(replaces={"cacheEquals"})
        static boolean isReadable(RegexResult receiver, String symbol) {
            return KEYS.contains(symbol);
        }
    }

    @ExportMessage
    static abstract class ReadMember {
        ReadMember() {
        }

        @Specialization(guards={"symbol == cachedSymbol", "cachedSymbol.equals(PROP_IS_MATCH)"}, limit="2")
        static boolean isMatchIdentity(RegexResult receiver, String symbol, @Cached(value="symbol") String cachedSymbol) {
            return receiver != RegexResult.getNoMatchInstance();
        }

        @Specialization(guards={"symbol.equals(cachedSymbol)", "cachedSymbol.equals(PROP_IS_MATCH)"}, limit="2", replaces={"isMatchIdentity"})
        static boolean isMatchEquals(RegexResult receiver, String symbol, @Cached(value="symbol") String cachedSymbol) {
            return receiver != RegexResult.getNoMatchInstance();
        }

        @Specialization(guards={"symbol == cachedSymbol", "cachedSymbol.equals(PROP_GET_START)"}, limit="2")
        static RegexResultGetStartMethod getStartIdentity(RegexResult receiver, String symbol, @Cached(value="symbol") String cachedSymbol) {
            return new RegexResultGetStartMethod(receiver);
        }

        @Specialization(guards={"symbol.equals(cachedSymbol)", "cachedSymbol.equals(PROP_GET_START)"}, limit="2", replaces={"getStartIdentity"})
        static RegexResultGetStartMethod getStartEquals(RegexResult receiver, String symbol, @Cached(value="symbol") String cachedSymbol) {
            return new RegexResultGetStartMethod(receiver);
        }

        @Specialization(guards={"symbol == cachedSymbol", "cachedSymbol.equals(PROP_GET_END)"}, limit="2")
        static RegexResultGetEndMethod getEndIdentity(RegexResult receiver, String symbol, @Cached(value="symbol") String cachedSymbol) {
            return new RegexResultGetEndMethod(receiver);
        }

        @Specialization(guards={"symbol.equals(cachedSymbol)", "cachedSymbol.equals(PROP_GET_END)"}, limit="2", replaces={"getEndIdentity"})
        static RegexResultGetEndMethod getEndEquals(RegexResult receiver, String symbol, @Cached(value="symbol") String cachedSymbol) {
            return new RegexResultGetEndMethod(receiver);
        }

        @Specialization(replaces={"isMatchEquals", "getStartEquals", "getEndEquals"})
        @ReportPolymorphism.Megamorphic
        static Object readGeneric(RegexResult receiver, String symbol) throws UnknownIdentifierException {
            switch (symbol) {
                case "isMatch": {
                    return receiver != RegexResult.getNoMatchInstance();
                }
                case "getStart": {
                    return new RegexResultGetStartMethod(receiver);
                }
                case "getEnd": {
                    return new RegexResultGetEndMethod(receiver);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw UnknownIdentifierException.create(symbol);
        }
    }
}

