/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.dfa;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.regex.tregex.dfa.DFAGenerator;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFACaptureGroupTrackingData;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorNode;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonArray;
import com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import com.oracle.truffle.regex.tregex.util.json.JsonObject;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;
import java.util.Arrays;

public final class DFACaptureGroupPartialTransition
implements JsonConvertible {
    public static final int FINAL_STATE_RESULT_INDEX = 0;
    public static final byte[] EMPTY_REORDER_SWAPS = new byte[0];
    public static final byte[] EMPTY_ARRAY_COPIES = new byte[0];
    public static final IndexOperation[] EMPTY_INDEX_UPDATES = new IndexOperation[0];
    public static final IndexOperation[] EMPTY_INDEX_CLEARS = new IndexOperation[0];
    private static final DFACaptureGroupPartialTransition EMPTY_INSTANCE = new DFACaptureGroupPartialTransition(0, EMPTY_REORDER_SWAPS, EMPTY_ARRAY_COPIES, EMPTY_INDEX_UPDATES, EMPTY_INDEX_CLEARS, 0);
    private final int id;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final byte[] reorderSwaps;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final byte[] arrayCopies;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final IndexOperation[] indexUpdates;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final IndexOperation[] indexClears;
    private final byte preReorderFinalStateResultIndex;

    private DFACaptureGroupPartialTransition(int id, byte[] reorderSwaps, byte[] arrayCopies, IndexOperation[] indexUpdates, IndexOperation[] indexClears, byte preReorderFinalStateResultIndex) {
        this.id = id;
        this.reorderSwaps = reorderSwaps;
        this.arrayCopies = arrayCopies;
        this.indexUpdates = indexUpdates;
        this.indexClears = indexClears;
        this.preReorderFinalStateResultIndex = preReorderFinalStateResultIndex;
    }

    public static DFACaptureGroupPartialTransition create(DFAGenerator dfaGen, byte[] reorderSwaps, byte[] arrayCopies, IndexOperation[] indexUpdates, IndexOperation[] indexClears, byte preReorderFinalStateResultIndex) {
        assert ((reorderSwaps.length & 1) == 0) : "reorderSwaps must have an even number of elements";
        if (reorderSwaps.length == 0 && arrayCopies.length == 0 && indexUpdates.length == 0 && indexClears.length == 0 && preReorderFinalStateResultIndex == 0) {
            return DFACaptureGroupPartialTransition.getEmptyInstance();
        }
        return new DFACaptureGroupPartialTransition(dfaGen.getCgPartialTransitionIDCounter().inc(), reorderSwaps, arrayCopies, indexUpdates, indexClears, preReorderFinalStateResultIndex);
    }

    public static DFACaptureGroupPartialTransition getEmptyInstance() {
        return EMPTY_INSTANCE;
    }

    public int getId() {
        return this.id;
    }

    public boolean doesReorderResults() {
        return this.reorderSwaps.length > 0;
    }

    public byte[] getArrayCopies() {
        return this.arrayCopies;
    }

    public void apply(TRegexDFAExecutorNode executor, DFACaptureGroupTrackingData d, int currentIndex) {
        if (executor.recordExecution()) {
            executor.getDebugRecorder().recordCGPartialTransition(currentIndex, this.id);
        }
        CompilerAsserts.partialEvaluationConstant(this);
        this.applyReorder(d.currentResultOrder);
        this.applyArrayCopy(d.results, d.currentResultOrder, d.currentResult.length);
        this.applyIndexUpdate(d.results, d.currentResultOrder, currentIndex);
        this.applyIndexClear(d.results, d.currentResultOrder);
    }

    public void applyPreFinalStateTransition(TRegexDFAExecutorNode executor, DFACaptureGroupTrackingData d, int currentIndex) {
        CompilerAsserts.partialEvaluationConstant(this);
        if (!executor.isSearching()) {
            this.apply(executor, d, currentIndex);
            return;
        }
        if (executor.recordExecution()) {
            executor.getDebugRecorder().recordCGPartialTransition(currentIndex, this.id);
        }
        d.exportResult(this.preReorderFinalStateResultIndex);
        this.applyFinalStateTransition(executor, d, currentIndex);
    }

    public void applyFinalStateTransition(TRegexDFAExecutorNode executor, DFACaptureGroupTrackingData d, int currentIndex) {
        CompilerAsserts.partialEvaluationConstant(this);
        if (!executor.isSearching()) {
            this.apply(executor, d, currentIndex);
            return;
        }
        if (executor.recordExecution()) {
            executor.getDebugRecorder().recordCGPartialTransition(currentIndex, this.id);
        }
        assert (this.arrayCopies.length == 0);
        assert (this.indexUpdates.length <= 1);
        assert (this.indexClears.length <= 1);
        if (this.indexUpdates.length == 1) {
            assert (this.indexUpdates[0].targetArray == 0);
            this.applyFinalStateTransitionIndexUpdates(d, currentIndex);
        }
        if (this.indexClears.length == 1) {
            assert (this.indexClears[0].targetArray == 0);
            this.applyFinalStateTransitionIndexClears(d);
        }
    }

    @ExplodeLoop
    private void applyFinalStateTransitionIndexUpdates(DFACaptureGroupTrackingData d, int currentIndex) {
        for (int i = 0; i < this.indexUpdates[0].getNumberOfIndices(); ++i) {
            d.currentResult[this.indexUpdates[0].getIndex((int)i)] = currentIndex;
        }
    }

    @ExplodeLoop
    private void applyFinalStateTransitionIndexClears(DFACaptureGroupTrackingData d) {
        for (int i = 0; i < this.indexClears[0].getNumberOfIndices(); ++i) {
            d.currentResult[this.indexClears[0].getIndex((int)i)] = -1;
        }
    }

    @ExplodeLoop
    private void applyReorder(int[] currentResultOrder) {
        for (int i = 0; i < this.reorderSwaps.length; i += 2) {
            int source = Byte.toUnsignedInt(this.reorderSwaps[i]);
            int target = Byte.toUnsignedInt(this.reorderSwaps[i + 1]);
            int tmp = currentResultOrder[source];
            currentResultOrder[source] = currentResultOrder[target];
            currentResultOrder[target] = tmp;
        }
    }

    @ExplodeLoop
    private void applyArrayCopy(int[] results, int[] currentResultOrder, int length) {
        for (int i = 0; i < this.arrayCopies.length; i += 2) {
            int source = Byte.toUnsignedInt(this.arrayCopies[i]);
            int target = Byte.toUnsignedInt(this.arrayCopies[i + 1]);
            System.arraycopy(results, currentResultOrder[source], results, currentResultOrder[target], length);
        }
    }

    @ExplodeLoop
    private void applyIndexUpdate(int[] results, int[] currentResultOrder, int currentIndex) {
        for (IndexOperation indexUpdate : this.indexUpdates) {
            int targetArray = indexUpdate.getTargetArray();
            for (int i = 0; i < indexUpdate.getNumberOfIndices(); ++i) {
                results[currentResultOrder[targetArray] + indexUpdate.getIndex((int)i)] = currentIndex;
            }
        }
    }

    @ExplodeLoop
    private void applyIndexClear(int[] results, int[] currentResultOrder) {
        for (IndexOperation indexClear : this.indexClears) {
            int targetArray = indexClear.getTargetArray();
            for (int i = 0; i < indexClear.getNumberOfIndices(); ++i) {
                results[currentResultOrder[targetArray] + indexClear.getIndex((int)i)] = -1;
            }
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DFACaptureGroupPartialTransition)) {
            return false;
        }
        DFACaptureGroupPartialTransition o = (DFACaptureGroupPartialTransition)obj;
        return Arrays.equals(this.reorderSwaps, o.reorderSwaps) && Arrays.equals(this.arrayCopies, o.arrayCopies) && Arrays.deepEquals(this.indexUpdates, o.indexUpdates) && Arrays.deepEquals(this.indexClears, o.indexClears);
    }

    public int hashCode() {
        int prime = 31;
        int result = Arrays.hashCode(this.reorderSwaps);
        result = 31 * result + Arrays.hashCode(this.arrayCopies);
        result = 31 * result + Arrays.deepHashCode(this.indexUpdates);
        result = 31 * result + Arrays.deepHashCode(this.indexClears);
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        StringBuilder sb = new StringBuilder("DfaCGTransition");
        if (this.reorderSwaps.length > 0) {
            sb.append(System.lineSeparator()).append("reorderSwaps: ").append(Arrays.toString(this.reorderSwaps));
        }
        if (this.arrayCopies.length > 0) {
            sb.append(System.lineSeparator()).append("arrayCopies: ");
            for (int i = 0; i < this.arrayCopies.length; i += 2) {
                int source = Byte.toUnsignedInt(this.arrayCopies[i]);
                int target = Byte.toUnsignedInt(this.arrayCopies[i + 1]);
                sb.append(System.lineSeparator()).append("    ").append(source).append(" -> ").append(target);
            }
        }
        DFACaptureGroupPartialTransition.indexManipulationsToString(sb, this.indexUpdates, "indexUpdates");
        DFACaptureGroupPartialTransition.indexManipulationsToString(sb, this.indexClears, "indexClears");
        return sb.toString();
    }

    @CompilerDirectives.TruffleBoundary
    private static void indexManipulationsToString(StringBuilder sb, IndexOperation[] indexManipulations, String name) {
        if (indexManipulations.length > 0) {
            sb.append(System.lineSeparator()).append(name).append(": ");
            for (IndexOperation indexManipulation : indexManipulations) {
                int targetArray = indexManipulation.getTargetArray();
                sb.append(System.lineSeparator()).append("    ").append(targetArray).append(" <- [");
                for (int i = 0; i < indexManipulation.getNumberOfIndices(); ++i) {
                    if (i > 1) {
                        sb.append(", ");
                    }
                    sb.append(indexManipulation.getIndex(i));
                }
                sb.append("]");
            }
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        JsonObject json = Json.obj(Json.prop("id", this.id), Json.prop("reorderSwaps", Json.arrayUnsigned(this.reorderSwaps)));
        JsonArray copies = Json.array(new JsonConvertible[0]);
        for (int i = 0; i < this.arrayCopies.length; i += 2) {
            int source = Byte.toUnsignedInt(this.arrayCopies[i]);
            int target = Byte.toUnsignedInt(this.arrayCopies[i + 1]);
            copies.append(Json.obj(Json.prop("source", source), Json.prop("target", target)));
        }
        json.append(Json.prop("arrayCopies", copies));
        for (IndexOperation indexUpdate : this.indexUpdates) {
            json.append(Json.prop("indexUpdates", indexUpdate));
        }
        for (IndexOperation indexClear : this.indexClears) {
            json.append(Json.prop("indexClears", indexClear));
        }
        return json;
    }

    public static final class IndexOperation
    implements JsonConvertible {
        private final byte targetArray;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final byte[] indices;

        public IndexOperation(int targetArray, byte[] indices) {
            assert (targetArray < 256);
            this.targetArray = (byte)targetArray;
            this.indices = indices;
        }

        public int getTargetArray() {
            return Byte.toUnsignedInt(this.targetArray);
        }

        public int getNumberOfIndices() {
            return this.indices.length;
        }

        public int getIndex(int i) {
            return Byte.toUnsignedInt(this.indices[i]);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public JsonValue toJson() {
            return Json.obj(Json.prop("target", this.getTargetArray()), Json.prop("groupStarts", IndexOperation.groupEntriesToJsonArray(this.indices)), Json.prop("groupEnds", IndexOperation.groupExitsToJsonArray(this.indices)));
        }

        @CompilerDirectives.TruffleBoundary
        private static JsonArray groupEntriesToJsonArray(byte[] gbArray) {
            return IndexOperation.groupBoundariesToJsonArray(gbArray, true);
        }

        @CompilerDirectives.TruffleBoundary
        private static JsonArray groupExitsToJsonArray(byte[] gbArray) {
            return IndexOperation.groupBoundariesToJsonArray(gbArray, false);
        }

        @CompilerDirectives.TruffleBoundary
        private static JsonArray groupBoundariesToJsonArray(byte[] gbArray, boolean entries) {
            JsonArray array = Json.array(new JsonConvertible[0]);
            for (int i = 0; i < gbArray.length; ++i) {
                int intValue = Byte.toUnsignedInt(gbArray[i]);
                if ((intValue & 1) != (entries ? 0 : 1)) continue;
                array.append(Json.val(intValue / 2));
            }
            return array;
        }

        @CompilerDirectives.TruffleBoundary
        public static JsonValue groupBoundariesToJsonObject(byte[] arr) {
            return Json.obj(Json.prop("groupStarts", IndexOperation.groupEntriesToJsonArray(arr)), Json.prop("groupEnds", IndexOperation.groupExitsToJsonArray(arr)));
        }
    }
}

