/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.input;

import com.oracle.truffle.api.ArrayUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.regex.RegexRootNode;
import com.oracle.truffle.regex.tregex.nodes.input.InputIndexOfStringNodeGen;
import com.oracle.truffle.regex.tregex.nodes.input.InputLengthNode;
import com.oracle.truffle.regex.tregex.nodes.input.InputRegionMatchesNode;

public abstract class InputIndexOfStringNode
extends Node {
    public static InputIndexOfStringNode create() {
        return InputIndexOfStringNodeGen.create();
    }

    public abstract int execute(Object var1, int var2, int var3, Object var4, Object var5);

    @Specialization(guards={"mask == null"})
    public int doBytes(byte[] input, int fromIndex, int maxIndex, byte[] match, Object mask) {
        return ArrayUtils.indexOfWithOrMask(input, fromIndex, maxIndex - fromIndex, match, null);
    }

    @Specialization(guards={"mask != null"})
    public int doBytesMask(byte[] input, int fromIndex, int maxIndex, byte[] match, byte[] mask) {
        return ArrayUtils.indexOfWithOrMask(input, fromIndex, maxIndex - fromIndex, match, mask);
    }

    @Specialization(guards={"mask == null"})
    public int doString(String input, int fromIndex, int maxIndex, String match, Object mask) {
        int result = input.indexOf(match, fromIndex);
        return result >= maxIndex ? -1 : result;
    }

    @Specialization(guards={"mask != null"})
    public int doStringMask(String input, int fromIndex, int maxIndex, String match, String mask) {
        return ArrayUtils.indexOfWithOrMask(input, fromIndex, maxIndex - fromIndex, match, mask);
    }

    @Specialization(guards={"neitherByteArrayNorString(input)"})
    public int doTruffleObjBytes(Object input, int fromIndex, int maxIndex, byte[] match, Object mask, @Cached InputLengthNode lengthNode, @Cached InputRegionMatchesNode regionMatchesNode) {
        if (maxIndex > lengthNode.execute(input)) {
            return -1;
        }
        if (fromIndex + match.length > maxIndex) {
            return -1;
        }
        for (int i = fromIndex; i <= maxIndex - match.length; ++i) {
            if (CompilerDirectives.inInterpreter()) {
                RegexRootNode.checkThreadInterrupted();
            }
            if (!regionMatchesNode.execute(input, i, match, 0, match.length, mask)) continue;
            return i;
        }
        return -1;
    }

    @Specialization(guards={"neitherByteArrayNorString(input)"})
    public int doTruffleObjString(Object input, int fromIndex, int maxIndex, String match, Object mask, @Cached InputLengthNode lengthNode, @Cached InputRegionMatchesNode regionMatchesNode) {
        if (maxIndex > lengthNode.execute(input)) {
            return -1;
        }
        if (fromIndex + match.length() > maxIndex) {
            return -1;
        }
        for (int i = fromIndex; i <= maxIndex - match.length(); ++i) {
            if (CompilerDirectives.inInterpreter()) {
                RegexRootNode.checkThreadInterrupted();
            }
            if (!regionMatchesNode.execute(input, i, match, 0, match.length(), mask)) continue;
            return i;
        }
        return -1;
    }

    protected static boolean neitherByteArrayNorString(Object obj) {
        return !(obj instanceof byte[]) && !(obj instanceof String);
    }
}

