/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.container.impl.deployment;

import java.util.Map;
import org.cibseven.bpm.application.impl.metadata.spi.ProcessArchiveXml;
import org.cibseven.bpm.container.impl.deployment.util.DeployedProcessArchive;
import org.cibseven.bpm.container.impl.jmx.services.JmxManagedProcessApplication;
import org.cibseven.bpm.container.impl.metadata.PropertyHelper;
import org.cibseven.bpm.container.impl.spi.DeploymentOperation;
import org.cibseven.bpm.container.impl.spi.DeploymentOperationStep;
import org.cibseven.bpm.container.impl.spi.PlatformServiceContainer;
import org.cibseven.bpm.container.impl.spi.ServiceTypes;
import org.cibseven.bpm.engine.ProcessEngine;
import org.cibseven.bpm.engine.RepositoryService;

public class UndeployProcessArchiveStep
extends DeploymentOperationStep {
    protected String processArchvieName;
    protected JmxManagedProcessApplication deployedProcessApplication;
    protected ProcessArchiveXml processArchive;
    protected String processEngineName;

    public UndeployProcessArchiveStep(JmxManagedProcessApplication deployedProcessApplication, ProcessArchiveXml processArchive, String processEngineName) {
        this.deployedProcessApplication = deployedProcessApplication;
        this.processArchive = processArchive;
        this.processEngineName = processEngineName;
    }

    @Override
    public String getName() {
        return "Undeploying process archvie " + this.processArchvieName;
    }

    @Override
    public void performOperationStep(DeploymentOperation operationContext) {
        PlatformServiceContainer serviceContainer = operationContext.getServiceContainer();
        Map<String, DeployedProcessArchive> processArchiveDeploymentMap = this.deployedProcessApplication.getProcessArchiveDeploymentMap();
        DeployedProcessArchive deployedProcessArchive = processArchiveDeploymentMap.get(this.processArchive.getName());
        ProcessEngine processEngine = (ProcessEngine)serviceContainer.getServiceValue(ServiceTypes.PROCESS_ENGINE, this.processEngineName);
        processEngine.getManagementService().unregisterProcessApplication(deployedProcessArchive.getAllDeploymentIds(), true);
        if (PropertyHelper.getBooleanProperty(this.processArchive.getProperties(), "isDeleteUponUndeploy", false) && processEngine != null) {
            this.deleteDeployment(deployedProcessArchive.getPrimaryDeploymentId(), processEngine.getRepositoryService());
        }
    }

    protected void deleteDeployment(String deploymentId, RepositoryService repositoryService) {
        repositoryService.deleteDeployment(deploymentId, true, true);
    }
}

