/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.container.impl.deployment.scanning;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cibseven.bpm.container.impl.ContainerIntegrationLogger;
import org.cibseven.bpm.container.impl.deployment.scanning.ProcessApplicationScanningUtil;
import org.cibseven.bpm.container.impl.deployment.scanning.spi.ProcessApplicationScanner;
import org.cibseven.bpm.engine.impl.ProcessEngineLogger;
import org.cibseven.bpm.engine.impl.util.IoUtil;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;

public class VfsProcessApplicationScanner
implements ProcessApplicationScanner {
    private static final ContainerIntegrationLogger LOG = ProcessEngineLogger.CONTAINER_INTEGRATION_LOGGER;

    @Override
    public Map<String, byte[]> findResources(ClassLoader classLoader, String resourceRootPath, URL processesXml) {
        return this.findResources(classLoader, resourceRootPath, processesXml, null);
    }

    @Override
    public Map<String, byte[]> findResources(ClassLoader classLoader, String resourceRootPath, URL processesXml, String[] additionalResourceSuffixes) {
        HashMap<String, byte[]> resources = new HashMap<String, byte[]>();
        if (resourceRootPath != null && !resourceRootPath.startsWith("pa:")) {
            String strippedPath = resourceRootPath.replace("classpath:", "");
            Enumeration<URL> resourceRoots = this.loadClasspathResourceRoots(classLoader, strippedPath);
            if (!resourceRoots.hasMoreElements()) {
                LOG.cannotFindResourcesForPath(resourceRootPath, classLoader);
            }
            while (resourceRoots.hasMoreElements()) {
                URL resourceRoot = resourceRoots.nextElement();
                VirtualFile virtualRoot = this.getVirtualFileForUrl(resourceRoot);
                this.scanRoot(virtualRoot, additionalResourceSuffixes, resources);
            }
        } else if (processesXml != null) {
            VirtualFile virtualFile = this.getVirtualFileForUrl(processesXml);
            VirtualFile resourceRoot = virtualFile.getParent().getParent();
            if (resourceRootPath != null) {
                String strippedPath = resourceRootPath.replace("pa:", "");
                resourceRoot = resourceRoot.getChild(strippedPath);
            }
            this.scanRoot(resourceRoot, additionalResourceSuffixes, resources);
        }
        return resources;
    }

    protected VirtualFile getVirtualFileForUrl(URL url) {
        try {
            return VFS.getChild((URI)url.toURI());
        }
        catch (URISyntaxException e) {
            throw LOG.exceptionWhileGettingVirtualFolder(url, e);
        }
    }

    protected void scanRoot(VirtualFile processArchiveRoot, final String[] additionalResourceSuffixes, Map<String, byte[]> resources) {
        try {
            List processes = processArchiveRoot.getChildrenRecursively(new VirtualFileFilter(){

                public boolean accepts(VirtualFile file) {
                    return file.isFile() && ProcessApplicationScanningUtil.isDeployable(file.getName(), additionalResourceSuffixes);
                }
            });
            for (final VirtualFile process : processes) {
                this.addResource(process, processArchiveRoot, resources);
                List diagrams = process.getParent().getChildren(new VirtualFileFilter(){

                    public boolean accepts(VirtualFile file) {
                        return ProcessApplicationScanningUtil.isDiagram(file.getName(), process.getName());
                    }
                });
                for (VirtualFile diagram : diagrams) {
                    this.addResource(diagram, processArchiveRoot, resources);
                }
            }
        }
        catch (IOException e) {
            LOG.cannotScanVfsRoot(processArchiveRoot, e);
        }
    }

    private void addResource(VirtualFile virtualFile, VirtualFile processArchiveRoot, Map<String, byte[]> resources) {
        String resourceName = virtualFile.getPathNameRelativeTo(processArchiveRoot);
        try {
            InputStream inputStream = virtualFile.openStream();
            byte[] bytes = IoUtil.readInputStream(inputStream, resourceName);
            IoUtil.closeSilently(inputStream);
            resources.put(resourceName, bytes);
        }
        catch (IOException e) {
            LOG.cannotReadInputStreamForFile(resourceName, processArchiveRoot, e);
        }
    }

    protected Enumeration<URL> loadClasspathResourceRoots(ClassLoader classLoader, String strippedPaResourceRootPath) {
        try {
            return classLoader.getResources(strippedPaResourceRootPath);
        }
        catch (IOException e) {
            throw LOG.exceptionWhileLoadingCpRoots(strippedPaResourceRootPath, classLoader, e);
        }
    }
}

