/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.cibseven.bpm.engine.ProcessEngineException;
import org.cibseven.bpm.engine.authorization.MissingAuthorization;

public class AuthorizationException
extends ProcessEngineException {
    private static final long serialVersionUID = 1L;
    protected final String userId;
    protected final List<MissingAuthorization> missingAuthorizations;
    @Deprecated
    protected String resourceType;
    @Deprecated
    protected String permissionName;
    @Deprecated
    protected String resourceId;

    public AuthorizationException(String message) {
        super(message);
        this.userId = null;
        this.missingAuthorizations = new ArrayList<MissingAuthorization>();
    }

    public AuthorizationException(String userId, String permissionName, String resourceType, String resourceId) {
        this(userId, new MissingAuthorization(permissionName, resourceType, resourceId));
    }

    public AuthorizationException(String userId, MissingAuthorization exceptionInfo) {
        super("The user with id '" + userId + "' does not have " + AuthorizationException.generateMissingAuthorizationMessage(exceptionInfo) + ".");
        this.userId = userId;
        this.missingAuthorizations = new ArrayList<MissingAuthorization>();
        this.missingAuthorizations.add(exceptionInfo);
        this.resourceType = exceptionInfo.getResourceType();
        this.permissionName = exceptionInfo.getViolatedPermissionName();
        this.resourceId = exceptionInfo.getResourceId();
    }

    public AuthorizationException(String userId, List<MissingAuthorization> info) {
        super(AuthorizationException.generateExceptionMessage(userId, info));
        this.userId = userId;
        this.missingAuthorizations = info;
    }

    @Deprecated
    public String getResourceType() {
        String resourceType = null;
        if (this.missingAuthorizations.size() == 1) {
            resourceType = this.missingAuthorizations.get(0).getResourceType();
        }
        return resourceType;
    }

    @Deprecated
    public String getViolatedPermissionName() {
        if (this.missingAuthorizations.size() == 1) {
            return this.missingAuthorizations.get(0).getViolatedPermissionName();
        }
        return null;
    }

    public String getUserId() {
        return this.userId;
    }

    @Deprecated
    public String getResourceId() {
        if (this.missingAuthorizations.size() == 1) {
            return this.missingAuthorizations.get(0).getResourceId();
        }
        return null;
    }

    public List<MissingAuthorization> getMissingAuthorizations() {
        return Collections.unmodifiableList(this.missingAuthorizations);
    }

    private static String generateExceptionMessage(String userId, List<MissingAuthorization> missingAuthorizations) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("The user with id '");
        sBuilder.append(userId);
        sBuilder.append("' does not have one of the following permissions: ");
        sBuilder.append(AuthorizationException.generateMissingAuthorizationsList(missingAuthorizations));
        return sBuilder.toString();
    }

    public static String generateMissingAuthorizationsList(List<MissingAuthorization> missingAuthorizations) {
        StringBuilder sBuilder = new StringBuilder();
        boolean first = true;
        for (MissingAuthorization missingAuthorization : missingAuthorizations) {
            if (!first) {
                sBuilder.append(" or ");
            } else {
                first = false;
            }
            sBuilder.append(AuthorizationException.generateMissingAuthorizationMessage(missingAuthorization));
        }
        return sBuilder.toString();
    }

    private static String generateMissingAuthorizationMessage(MissingAuthorization exceptionInfo) {
        StringBuilder builder = new StringBuilder();
        String permissionName = exceptionInfo.getViolatedPermissionName();
        String resourceType = exceptionInfo.getResourceType();
        String resourceId = exceptionInfo.getResourceId();
        builder.append("'");
        builder.append(permissionName);
        builder.append("' permission on resource '");
        builder.append((String)(resourceId != null ? resourceId + "' of type '" : ""));
        builder.append(resourceType);
        builder.append("'");
        return builder.toString();
    }
}

