/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.cibseven.bpm.engine.impl.AbstractQueryVariableValueCondition;
import org.cibseven.bpm.engine.impl.QueryVariableValue;
import org.cibseven.bpm.engine.impl.SingleQueryVariableValueCondition;
import org.cibseven.bpm.engine.impl.context.Context;
import org.cibseven.bpm.engine.impl.variable.serializer.VariableSerializers;
import org.cibseven.bpm.engine.variable.type.ValueType;
import org.cibseven.bpm.engine.variable.type.ValueTypeResolver;
import org.cibseven.bpm.engine.variable.value.TypedValue;

public class CompositeQueryVariableValueCondition
extends AbstractQueryVariableValueCondition {
    protected List<SingleQueryVariableValueCondition> aggregatedValues = new ArrayList<SingleQueryVariableValueCondition>();

    public CompositeQueryVariableValueCondition(QueryVariableValue variableValue) {
        super(variableValue);
    }

    @Override
    public void initializeValue(VariableSerializers serializers, String dbType) {
        TypedValue typedValue = this.wrappedQueryValue.getTypedValue();
        ValueTypeResolver resolver = Context.getProcessEngineConfiguration().getValueTypeResolver();
        Collection concreteTypes = resolver.getSubTypes(typedValue.getType());
        for (ValueType type : concreteTypes) {
            if (!type.canConvertFromTypedValue(typedValue)) continue;
            TypedValue convertedValue = type.convertFromTypedValue(typedValue);
            SingleQueryVariableValueCondition aggregatedValue = new SingleQueryVariableValueCondition(this.wrappedQueryValue);
            aggregatedValue.initializeValue(serializers, convertedValue, dbType);
            this.aggregatedValues.add(aggregatedValue);
        }
    }

    @Override
    public List<SingleQueryVariableValueCondition> getDisjunctiveConditions() {
        return this.aggregatedValues;
    }
}

