/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cibseven.bpm.engine.BadUserRequestException;
import org.cibseven.bpm.engine.ProcessEngineException;
import org.cibseven.bpm.engine.RuntimeService;
import org.cibseven.bpm.engine.batch.Batch;
import org.cibseven.bpm.engine.form.FormData;
import org.cibseven.bpm.engine.history.HistoricProcessInstanceQuery;
import org.cibseven.bpm.engine.impl.ConditionEvaluationBuilderImpl;
import org.cibseven.bpm.engine.impl.EventSubscriptionQueryImpl;
import org.cibseven.bpm.engine.impl.ExecutionQueryImpl;
import org.cibseven.bpm.engine.impl.IncidentQueryImpl;
import org.cibseven.bpm.engine.impl.MessageCorrelationAsyncBuilderImpl;
import org.cibseven.bpm.engine.impl.MessageCorrelationBuilderImpl;
import org.cibseven.bpm.engine.impl.ModificationBuilderImpl;
import org.cibseven.bpm.engine.impl.NativeExecutionQueryImpl;
import org.cibseven.bpm.engine.impl.NativeProcessInstanceQueryImpl;
import org.cibseven.bpm.engine.impl.ProcessInstanceModificationBuilderImpl;
import org.cibseven.bpm.engine.impl.ProcessInstanceQueryImpl;
import org.cibseven.bpm.engine.impl.ProcessInstantiationBuilderImpl;
import org.cibseven.bpm.engine.impl.RestartProcessInstanceBuilderImpl;
import org.cibseven.bpm.engine.impl.ServiceImpl;
import org.cibseven.bpm.engine.impl.SignalEventReceivedBuilderImpl;
import org.cibseven.bpm.engine.impl.VariableInstanceQueryImpl;
import org.cibseven.bpm.engine.impl.cmd.CreateIncidentCmd;
import org.cibseven.bpm.engine.impl.cmd.DeleteProcessInstanceCmd;
import org.cibseven.bpm.engine.impl.cmd.DeleteProcessInstancesCmd;
import org.cibseven.bpm.engine.impl.cmd.FindActiveActivityIdsCmd;
import org.cibseven.bpm.engine.impl.cmd.GetActivityInstanceCmd;
import org.cibseven.bpm.engine.impl.cmd.GetExecutionVariableCmd;
import org.cibseven.bpm.engine.impl.cmd.GetExecutionVariableTypedCmd;
import org.cibseven.bpm.engine.impl.cmd.GetExecutionVariablesCmd;
import org.cibseven.bpm.engine.impl.cmd.GetStartFormCmd;
import org.cibseven.bpm.engine.impl.cmd.MessageEventReceivedCmd;
import org.cibseven.bpm.engine.impl.cmd.PatchExecutionVariablesCmd;
import org.cibseven.bpm.engine.impl.cmd.RemoveExecutionVariablesCmd;
import org.cibseven.bpm.engine.impl.cmd.ResolveIncidentCmd;
import org.cibseven.bpm.engine.impl.cmd.SetAnnotationForIncidentCmd;
import org.cibseven.bpm.engine.impl.cmd.SetExecutionVariablesCmd;
import org.cibseven.bpm.engine.impl.cmd.SignalCmd;
import org.cibseven.bpm.engine.impl.cmd.batch.DeleteProcessInstanceBatchCmd;
import org.cibseven.bpm.engine.impl.cmd.batch.variables.SetVariablesToProcessInstancesBatchCmd;
import org.cibseven.bpm.engine.impl.migration.MigrationPlanBuilderImpl;
import org.cibseven.bpm.engine.impl.migration.MigrationPlanExecutionBuilderImpl;
import org.cibseven.bpm.engine.impl.runtime.UpdateProcessInstanceSuspensionStateBuilderImpl;
import org.cibseven.bpm.engine.impl.util.EnsureUtil;
import org.cibseven.bpm.engine.impl.util.ExceptionUtil;
import org.cibseven.bpm.engine.migration.MigrationPlan;
import org.cibseven.bpm.engine.migration.MigrationPlanBuilder;
import org.cibseven.bpm.engine.migration.MigrationPlanExecutionBuilder;
import org.cibseven.bpm.engine.runtime.ActivityInstance;
import org.cibseven.bpm.engine.runtime.ConditionEvaluationBuilder;
import org.cibseven.bpm.engine.runtime.EventSubscriptionQuery;
import org.cibseven.bpm.engine.runtime.ExecutionQuery;
import org.cibseven.bpm.engine.runtime.Incident;
import org.cibseven.bpm.engine.runtime.IncidentQuery;
import org.cibseven.bpm.engine.runtime.MessageCorrelationAsyncBuilder;
import org.cibseven.bpm.engine.runtime.MessageCorrelationBuilder;
import org.cibseven.bpm.engine.runtime.ModificationBuilder;
import org.cibseven.bpm.engine.runtime.NativeExecutionQuery;
import org.cibseven.bpm.engine.runtime.NativeProcessInstanceQuery;
import org.cibseven.bpm.engine.runtime.ProcessInstance;
import org.cibseven.bpm.engine.runtime.ProcessInstanceModificationBuilder;
import org.cibseven.bpm.engine.runtime.ProcessInstanceQuery;
import org.cibseven.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.cibseven.bpm.engine.runtime.RestartProcessInstanceBuilder;
import org.cibseven.bpm.engine.runtime.SignalEventReceivedBuilder;
import org.cibseven.bpm.engine.runtime.UpdateProcessInstanceSuspensionStateSelectBuilder;
import org.cibseven.bpm.engine.runtime.VariableInstanceQuery;
import org.cibseven.bpm.engine.variable.VariableMap;
import org.cibseven.bpm.engine.variable.value.TypedValue;

public class RuntimeServiceImpl
extends ServiceImpl
implements RuntimeService {
    @Override
    public ProcessInstance startProcessInstanceByKey(String processDefinitionKey) {
        return this.createProcessInstanceByKey(processDefinitionKey).execute();
    }

    @Override
    public ProcessInstance startProcessInstanceByKey(String processDefinitionKey, String businessKey) {
        return this.createProcessInstanceByKey(processDefinitionKey).businessKey(businessKey).execute();
    }

    @Override
    public ProcessInstance startProcessInstanceByKey(String processDefinitionKey, String businessKey, String caseInstanceId) {
        return this.createProcessInstanceByKey(processDefinitionKey).businessKey(businessKey).caseInstanceId(caseInstanceId).execute();
    }

    @Override
    public ProcessInstance startProcessInstanceByKey(String processDefinitionKey, Map<String, Object> variables) {
        return ((ProcessInstantiationBuilder)this.createProcessInstanceByKey(processDefinitionKey).setVariables(variables)).execute();
    }

    @Override
    public ProcessInstance startProcessInstanceByKey(String processDefinitionKey, String businessKey, Map<String, Object> variables) {
        return ((ProcessInstantiationBuilder)this.createProcessInstanceByKey(processDefinitionKey).businessKey(businessKey).setVariables(variables)).execute();
    }

    @Override
    public ProcessInstance startProcessInstanceByKey(String processDefinitionKey, String businessKey, String caseInstanceId, Map<String, Object> variables) {
        return ((ProcessInstantiationBuilder)this.createProcessInstanceByKey(processDefinitionKey).businessKey(businessKey).caseInstanceId(caseInstanceId).setVariables(variables)).execute();
    }

    @Override
    public ProcessInstance startProcessInstanceById(String processDefinitionId) {
        return this.createProcessInstanceById(processDefinitionId).execute();
    }

    @Override
    public ProcessInstance startProcessInstanceById(String processDefinitionId, String businessKey) {
        return this.createProcessInstanceById(processDefinitionId).businessKey(businessKey).execute();
    }

    @Override
    public ProcessInstance startProcessInstanceById(String processDefinitionId, String businessKey, String caseInstanceId) {
        return this.createProcessInstanceById(processDefinitionId).businessKey(businessKey).caseInstanceId(caseInstanceId).execute();
    }

    @Override
    public ProcessInstance startProcessInstanceById(String processDefinitionId, Map<String, Object> variables) {
        return ((ProcessInstantiationBuilder)this.createProcessInstanceById(processDefinitionId).setVariables(variables)).execute();
    }

    @Override
    public ProcessInstance startProcessInstanceById(String processDefinitionId, String businessKey, Map<String, Object> variables) {
        return ((ProcessInstantiationBuilder)this.createProcessInstanceById(processDefinitionId).businessKey(businessKey).setVariables(variables)).execute();
    }

    @Override
    public ProcessInstance startProcessInstanceById(String processDefinitionId, String businessKey, String caseInstanceId, Map<String, Object> variables) {
        return ((ProcessInstantiationBuilder)this.createProcessInstanceById(processDefinitionId).businessKey(businessKey).caseInstanceId(caseInstanceId).setVariables(variables)).execute();
    }

    @Override
    public void deleteProcessInstance(String processInstanceId, String deleteReason) {
        this.deleteProcessInstance(processInstanceId, deleteReason, false);
    }

    @Override
    public Batch deleteProcessInstancesAsync(List<String> processInstanceIds, ProcessInstanceQuery processInstanceQuery, String deleteReason) {
        return this.deleteProcessInstancesAsync(processInstanceIds, processInstanceQuery, deleteReason, false);
    }

    @Override
    public Batch deleteProcessInstancesAsync(List<String> processInstanceIds, String deleteReason) {
        return this.deleteProcessInstancesAsync(processInstanceIds, null, deleteReason, false);
    }

    @Override
    public Batch deleteProcessInstancesAsync(ProcessInstanceQuery processInstanceQuery, String deleteReason) {
        return this.deleteProcessInstancesAsync(null, processInstanceQuery, deleteReason, false);
    }

    @Override
    public Batch deleteProcessInstancesAsync(List<String> processInstanceIds, ProcessInstanceQuery processInstanceQuery, String deleteReason, boolean skipCustomListeners) {
        return this.deleteProcessInstancesAsync(processInstanceIds, processInstanceQuery, deleteReason, skipCustomListeners, false);
    }

    @Override
    public Batch deleteProcessInstancesAsync(List<String> processInstanceIds, ProcessInstanceQuery processInstanceQuery, String deleteReason, boolean skipCustomListeners, boolean skipSubprocesses) {
        return this.commandExecutor.execute(new DeleteProcessInstanceBatchCmd(processInstanceIds, processInstanceQuery, null, deleteReason, skipCustomListeners, skipSubprocesses, false));
    }

    @Override
    public Batch deleteProcessInstancesAsync(List<String> processInstanceIds, ProcessInstanceQuery processInstanceQuery, HistoricProcessInstanceQuery historicProcessInstanceQuery, String deleteReason, boolean skipCustomListeners, boolean skipSubprocesses) {
        return this.deleteProcessInstancesAsync(processInstanceIds, processInstanceQuery, historicProcessInstanceQuery, deleteReason, skipCustomListeners, skipSubprocesses, false);
    }

    @Override
    public Batch deleteProcessInstancesAsync(List<String> processInstanceIds, ProcessInstanceQuery processInstanceQuery, HistoricProcessInstanceQuery historicProcessInstanceQuery, String deleteReason, boolean skipCustomListeners, boolean skipSubprocesses, boolean skipIoMappings) {
        return this.commandExecutor.execute(new DeleteProcessInstanceBatchCmd(processInstanceIds, processInstanceQuery, historicProcessInstanceQuery, deleteReason, skipCustomListeners, skipSubprocesses, skipIoMappings));
    }

    @Override
    public void deleteProcessInstance(String processInstanceId, String deleteReason, boolean skipCustomListeners) {
        this.deleteProcessInstance(processInstanceId, deleteReason, skipCustomListeners, false);
    }

    @Override
    public void deleteProcessInstance(String processInstanceId, String deleteReason, boolean skipCustomListeners, boolean externallyTerminated) {
        this.deleteProcessInstance(processInstanceId, deleteReason, skipCustomListeners, externallyTerminated, false);
    }

    @Override
    public void deleteProcessInstance(String processInstanceId, String deleteReason, boolean skipCustomListeners, boolean externallyTerminated, boolean skipIoMappings) {
        this.deleteProcessInstance(processInstanceId, deleteReason, skipCustomListeners, externallyTerminated, skipIoMappings, false);
    }

    @Override
    public void deleteProcessInstance(String processInstanceId, String deleteReason, boolean skipCustomListeners, boolean externallyTerminated, boolean skipIoMappings, boolean skipSubprocesses) {
        this.commandExecutor.execute(new DeleteProcessInstanceCmd(processInstanceId, deleteReason, skipCustomListeners, externallyTerminated, skipIoMappings, skipSubprocesses, true));
    }

    @Override
    public void deleteProcessInstanceIfExists(String processInstanceId, String deleteReason, boolean skipCustomListeners, boolean externallyTerminated, boolean skipIoMappings, boolean skipSubprocesses) {
        this.commandExecutor.execute(new DeleteProcessInstanceCmd(processInstanceId, deleteReason, skipCustomListeners, externallyTerminated, skipIoMappings, skipSubprocesses, false));
    }

    @Override
    public void deleteProcessInstances(List<String> processInstanceIds, String deleteReason, boolean skipCustomListeners, boolean externallyTerminated) {
        this.deleteProcessInstances(processInstanceIds, deleteReason, skipCustomListeners, externallyTerminated, false, false);
    }

    @Override
    public void deleteProcessInstances(List<String> processInstanceIds, String deleteReason, boolean skipCustomListeners, boolean externallyTerminated, boolean skipSubprocesses) {
        this.deleteProcessInstances(processInstanceIds, deleteReason, skipCustomListeners, externallyTerminated, skipSubprocesses, false);
    }

    @Override
    public void deleteProcessInstances(List<String> processInstanceIds, String deleteReason, boolean skipCustomListeners, boolean externallyTerminated, boolean skipSubprocesses, boolean skipIoMappings) {
        this.commandExecutor.execute(new DeleteProcessInstancesCmd(processInstanceIds, deleteReason, skipCustomListeners, externallyTerminated, skipSubprocesses, true, skipIoMappings));
    }

    @Override
    public void deleteProcessInstancesIfExists(List<String> processInstanceIds, String deleteReason, boolean skipCustomListeners, boolean externallyTerminated, boolean skipSubprocesses) {
        this.commandExecutor.execute(new DeleteProcessInstancesCmd(processInstanceIds, deleteReason, skipCustomListeners, externallyTerminated, skipSubprocesses, false, false));
    }

    @Override
    public ExecutionQuery createExecutionQuery() {
        return new ExecutionQueryImpl(this.commandExecutor);
    }

    @Override
    public NativeExecutionQuery createNativeExecutionQuery() {
        return new NativeExecutionQueryImpl(this.commandExecutor);
    }

    @Override
    public NativeProcessInstanceQuery createNativeProcessInstanceQuery() {
        return new NativeProcessInstanceQueryImpl(this.commandExecutor);
    }

    @Override
    public IncidentQuery createIncidentQuery() {
        return new IncidentQueryImpl(this.commandExecutor);
    }

    @Override
    public EventSubscriptionQuery createEventSubscriptionQuery() {
        return new EventSubscriptionQueryImpl(this.commandExecutor);
    }

    @Override
    public VariableInstanceQuery createVariableInstanceQuery() {
        return new VariableInstanceQueryImpl(this.commandExecutor);
    }

    public VariableMap getVariables(String executionId) {
        return this.getVariablesTyped(executionId);
    }

    @Override
    public VariableMap getVariablesTyped(String executionId) {
        return this.getVariablesTyped(executionId, true);
    }

    @Override
    public VariableMap getVariablesTyped(String executionId, boolean deserializeObjectValues) {
        return this.commandExecutor.execute(new GetExecutionVariablesCmd(executionId, null, false, deserializeObjectValues));
    }

    public VariableMap getVariablesLocal(String executionId) {
        return this.getVariablesLocalTyped(executionId);
    }

    @Override
    public VariableMap getVariablesLocalTyped(String executionId) {
        return this.getVariablesLocalTyped(executionId, true);
    }

    @Override
    public VariableMap getVariablesLocalTyped(String executionId, boolean deserializeObjectValues) {
        return this.commandExecutor.execute(new GetExecutionVariablesCmd(executionId, null, true, deserializeObjectValues));
    }

    public VariableMap getVariables(String executionId, Collection<String> variableNames) {
        return this.getVariablesTyped(executionId, variableNames, true);
    }

    @Override
    public VariableMap getVariablesTyped(String executionId, Collection<String> variableNames, boolean deserializeObjectValues) {
        return this.commandExecutor.execute(new GetExecutionVariablesCmd(executionId, variableNames, false, deserializeObjectValues));
    }

    public VariableMap getVariablesLocal(String executionId, Collection<String> variableNames) {
        return this.getVariablesLocalTyped(executionId, variableNames, true);
    }

    @Override
    public VariableMap getVariablesLocalTyped(String executionId, Collection<String> variableNames, boolean deserializeObjectValues) {
        return this.commandExecutor.execute(new GetExecutionVariablesCmd(executionId, variableNames, true, deserializeObjectValues));
    }

    @Override
    public Object getVariable(String executionId, String variableName) {
        return this.commandExecutor.execute(new GetExecutionVariableCmd(executionId, variableName, false));
    }

    @Override
    public <T extends TypedValue> T getVariableTyped(String executionId, String variableName) {
        return this.getVariableTyped(executionId, variableName, true);
    }

    @Override
    public <T extends TypedValue> T getVariableTyped(String executionId, String variableName, boolean deserializeObjectValue) {
        return (T)((TypedValue)this.commandExecutor.execute(new GetExecutionVariableTypedCmd(executionId, variableName, false, deserializeObjectValue)));
    }

    @Override
    public <T extends TypedValue> T getVariableLocalTyped(String executionId, String variableName) {
        return this.getVariableLocalTyped(executionId, variableName, true);
    }

    @Override
    public <T extends TypedValue> T getVariableLocalTyped(String executionId, String variableName, boolean deserializeObjectValue) {
        return (T)((TypedValue)this.commandExecutor.execute(new GetExecutionVariableTypedCmd(executionId, variableName, true, deserializeObjectValue)));
    }

    @Override
    public Object getVariableLocal(String executionId, String variableName) {
        return this.commandExecutor.execute(new GetExecutionVariableCmd(executionId, variableName, true));
    }

    @Override
    public void setVariable(String executionId, String variableName, Object value) {
        EnsureUtil.ensureNotNull("variableName", (Object)variableName);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put(variableName, value);
        this.setVariables(executionId, variables);
    }

    @Override
    public void setVariableLocal(String executionId, String variableName, Object value) {
        EnsureUtil.ensureNotNull("variableName", (Object)variableName);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put(variableName, value);
        this.setVariablesLocal(executionId, variables);
    }

    @Override
    public void setVariables(String executionId, Map<String, ? extends Object> variables) {
        this.setVariables(executionId, variables, false);
    }

    @Override
    public void setVariablesLocal(String executionId, Map<String, ? extends Object> variables) {
        this.setVariables(executionId, variables, true);
    }

    protected void setVariables(String executionId, Map<String, ? extends Object> variables, boolean local) {
        try {
            this.commandExecutor.execute(new SetExecutionVariablesCmd(executionId, variables, local));
        }
        catch (ProcessEngineException ex) {
            if (ExceptionUtil.checkValueTooLongException(ex)) {
                throw new BadUserRequestException("Variable value is too long", ex);
            }
            throw ex;
        }
    }

    @Override
    public Batch setVariablesAsync(List<String> processInstanceIds, ProcessInstanceQuery processInstanceQuery, HistoricProcessInstanceQuery historicProcessInstanceQuery, Map<String, ?> variables) {
        return this.commandExecutor.execute(new SetVariablesToProcessInstancesBatchCmd(processInstanceIds, processInstanceQuery, historicProcessInstanceQuery, variables));
    }

    @Override
    public Batch setVariablesAsync(List<String> processInstanceIds, Map<String, ?> variables) {
        return this.commandExecutor.execute(new SetVariablesToProcessInstancesBatchCmd(processInstanceIds, null, null, variables));
    }

    @Override
    public Batch setVariablesAsync(ProcessInstanceQuery processInstanceQuery, Map<String, ?> variables) {
        return this.commandExecutor.execute(new SetVariablesToProcessInstancesBatchCmd(null, processInstanceQuery, null, variables));
    }

    @Override
    public Batch setVariablesAsync(HistoricProcessInstanceQuery historicProcessInstanceQuery, Map<String, ?> variables) {
        return this.commandExecutor.execute(new SetVariablesToProcessInstancesBatchCmd(null, null, historicProcessInstanceQuery, variables));
    }

    @Override
    public void removeVariable(String executionId, String variableName) {
        ArrayList<String> variableNames = new ArrayList<String>();
        variableNames.add(variableName);
        this.commandExecutor.execute(new RemoveExecutionVariablesCmd(executionId, variableNames, false));
    }

    @Override
    public void removeVariableLocal(String executionId, String variableName) {
        ArrayList<String> variableNames = new ArrayList<String>();
        variableNames.add(variableName);
        this.commandExecutor.execute(new RemoveExecutionVariablesCmd(executionId, variableNames, true));
    }

    @Override
    public void removeVariables(String executionId, Collection<String> variableNames) {
        this.commandExecutor.execute(new RemoveExecutionVariablesCmd(executionId, variableNames, false));
    }

    @Override
    public void removeVariablesLocal(String executionId, Collection<String> variableNames) {
        this.commandExecutor.execute(new RemoveExecutionVariablesCmd(executionId, variableNames, true));
    }

    public void updateVariables(String executionId, Map<String, ? extends Object> modifications, Collection<String> deletions) {
        this.updateVariables(executionId, modifications, deletions, false);
    }

    public void updateVariablesLocal(String executionId, Map<String, ? extends Object> modifications, Collection<String> deletions) {
        this.updateVariables(executionId, modifications, deletions, true);
    }

    protected void updateVariables(String executionId, Map<String, ? extends Object> modifications, Collection<String> deletions, boolean local) {
        try {
            this.commandExecutor.execute(new PatchExecutionVariablesCmd(executionId, modifications, deletions, local));
        }
        catch (ProcessEngineException ex) {
            if (ExceptionUtil.checkValueTooLongException(ex)) {
                throw new BadUserRequestException("Variable value is too long", ex);
            }
            throw ex;
        }
    }

    @Override
    public void signal(String executionId) {
        this.commandExecutor.execute(new SignalCmd(executionId, null, null, null));
    }

    @Override
    public void signal(String executionId, String signalName, Object signalData, Map<String, Object> processVariables) {
        this.commandExecutor.execute(new SignalCmd(executionId, signalName, signalData, processVariables));
    }

    @Override
    public void signal(String executionId, Map<String, Object> processVariables) {
        this.commandExecutor.execute(new SignalCmd(executionId, null, null, processVariables));
    }

    @Override
    public ProcessInstanceQuery createProcessInstanceQuery() {
        return new ProcessInstanceQueryImpl(this.commandExecutor);
    }

    @Override
    public List<String> getActiveActivityIds(String executionId) {
        return this.commandExecutor.execute(new FindActiveActivityIdsCmd(executionId));
    }

    @Override
    public ActivityInstance getActivityInstance(String processInstanceId) {
        return this.commandExecutor.execute(new GetActivityInstanceCmd(processInstanceId));
    }

    public FormData getFormInstanceById(String processDefinitionId) {
        return this.commandExecutor.execute(new GetStartFormCmd(processDefinitionId));
    }

    @Override
    public void suspendProcessInstanceById(String processInstanceId) {
        this.updateProcessInstanceSuspensionState().byProcessInstanceId(processInstanceId).suspend();
    }

    @Override
    public void suspendProcessInstanceByProcessDefinitionId(String processDefinitionId) {
        this.updateProcessInstanceSuspensionState().byProcessDefinitionId(processDefinitionId).suspend();
    }

    @Override
    public void suspendProcessInstanceByProcessDefinitionKey(String processDefinitionKey) {
        this.updateProcessInstanceSuspensionState().byProcessDefinitionKey(processDefinitionKey).suspend();
    }

    @Override
    public void activateProcessInstanceById(String processInstanceId) {
        this.updateProcessInstanceSuspensionState().byProcessInstanceId(processInstanceId).activate();
    }

    @Override
    public void activateProcessInstanceByProcessDefinitionId(String processDefinitionId) {
        this.updateProcessInstanceSuspensionState().byProcessDefinitionId(processDefinitionId).activate();
    }

    @Override
    public void activateProcessInstanceByProcessDefinitionKey(String processDefinitionKey) {
        this.updateProcessInstanceSuspensionState().byProcessDefinitionKey(processDefinitionKey).activate();
    }

    @Override
    public UpdateProcessInstanceSuspensionStateSelectBuilder updateProcessInstanceSuspensionState() {
        return new UpdateProcessInstanceSuspensionStateBuilderImpl(this.commandExecutor);
    }

    @Override
    public ProcessInstance startProcessInstanceByMessage(String messageName) {
        return this.createMessageCorrelation(messageName).correlateStartMessage();
    }

    @Override
    public ProcessInstance startProcessInstanceByMessage(String messageName, String businessKey) {
        return this.createMessageCorrelation(messageName).processInstanceBusinessKey(businessKey).correlateStartMessage();
    }

    @Override
    public ProcessInstance startProcessInstanceByMessage(String messageName, Map<String, Object> processVariables) {
        return this.createMessageCorrelation(messageName).setVariables(processVariables).correlateStartMessage();
    }

    @Override
    public ProcessInstance startProcessInstanceByMessage(String messageName, String businessKey, Map<String, Object> processVariables) {
        return this.createMessageCorrelation(messageName).processInstanceBusinessKey(businessKey).setVariables(processVariables).correlateStartMessage();
    }

    @Override
    public ProcessInstance startProcessInstanceByMessageAndProcessDefinitionId(String messageName, String processDefinitionId) {
        return this.createMessageCorrelation(messageName).processDefinitionId(processDefinitionId).correlateStartMessage();
    }

    @Override
    public ProcessInstance startProcessInstanceByMessageAndProcessDefinitionId(String messageName, String processDefinitionId, String businessKey) {
        return this.createMessageCorrelation(messageName).processDefinitionId(processDefinitionId).processInstanceBusinessKey(businessKey).correlateStartMessage();
    }

    @Override
    public ProcessInstance startProcessInstanceByMessageAndProcessDefinitionId(String messageName, String processDefinitionId, Map<String, Object> processVariables) {
        return this.createMessageCorrelation(messageName).processDefinitionId(processDefinitionId).setVariables(processVariables).correlateStartMessage();
    }

    @Override
    public ProcessInstance startProcessInstanceByMessageAndProcessDefinitionId(String messageName, String processDefinitionId, String businessKey, Map<String, Object> processVariables) {
        return this.createMessageCorrelation(messageName).processDefinitionId(processDefinitionId).processInstanceBusinessKey(businessKey).setVariables(processVariables).correlateStartMessage();
    }

    @Override
    public void signalEventReceived(String signalName) {
        this.createSignalEvent(signalName).send();
    }

    @Override
    public void signalEventReceived(String signalName, Map<String, Object> processVariables) {
        this.createSignalEvent(signalName).setVariables(processVariables).send();
    }

    @Override
    public void signalEventReceived(String signalName, String executionId) {
        this.createSignalEvent(signalName).executionId(executionId).send();
    }

    @Override
    public void signalEventReceived(String signalName, String executionId, Map<String, Object> processVariables) {
        this.createSignalEvent(signalName).executionId(executionId).setVariables(processVariables).send();
    }

    @Override
    public SignalEventReceivedBuilder createSignalEvent(String signalName) {
        return new SignalEventReceivedBuilderImpl(this.commandExecutor, signalName);
    }

    @Override
    public void messageEventReceived(String messageName, String executionId) {
        EnsureUtil.ensureNotNull("messageName", (Object)messageName);
        this.commandExecutor.execute(new MessageEventReceivedCmd(messageName, executionId, null));
    }

    @Override
    public void messageEventReceived(String messageName, String executionId, Map<String, Object> processVariables) {
        EnsureUtil.ensureNotNull("messageName", (Object)messageName);
        this.commandExecutor.execute(new MessageEventReceivedCmd(messageName, executionId, processVariables));
    }

    @Override
    public MessageCorrelationBuilder createMessageCorrelation(String messageName) {
        return new MessageCorrelationBuilderImpl(this.commandExecutor, messageName);
    }

    @Override
    public void correlateMessage(String messageName, Map<String, Object> correlationKeys, Map<String, Object> processVariables) {
        this.createMessageCorrelation(messageName).processInstanceVariablesEqual(correlationKeys).setVariables(processVariables).correlate();
    }

    @Override
    public void correlateMessage(String messageName, String businessKey, Map<String, Object> correlationKeys, Map<String, Object> processVariables) {
        this.createMessageCorrelation(messageName).processInstanceVariablesEqual(correlationKeys).processInstanceBusinessKey(businessKey).setVariables(processVariables).correlate();
    }

    @Override
    public void correlateMessage(String messageName) {
        this.createMessageCorrelation(messageName).correlate();
    }

    @Override
    public void correlateMessage(String messageName, String businessKey) {
        this.createMessageCorrelation(messageName).processInstanceBusinessKey(businessKey).correlate();
    }

    @Override
    public void correlateMessage(String messageName, Map<String, Object> correlationKeys) {
        this.createMessageCorrelation(messageName).processInstanceVariablesEqual(correlationKeys).correlate();
    }

    @Override
    public void correlateMessage(String messageName, String businessKey, Map<String, Object> processVariables) {
        this.createMessageCorrelation(messageName).processInstanceBusinessKey(businessKey).setVariables(processVariables).correlate();
    }

    @Override
    public MessageCorrelationAsyncBuilder createMessageCorrelationAsync(String messageName) {
        return new MessageCorrelationAsyncBuilderImpl(this.commandExecutor, messageName);
    }

    @Override
    public ProcessInstanceModificationBuilder createProcessInstanceModification(String processInstanceId) {
        return new ProcessInstanceModificationBuilderImpl(this.commandExecutor, processInstanceId);
    }

    @Override
    public ProcessInstantiationBuilder createProcessInstanceById(String processDefinitionId) {
        return ProcessInstantiationBuilderImpl.createProcessInstanceById(this.commandExecutor, processDefinitionId);
    }

    @Override
    public ProcessInstantiationBuilder createProcessInstanceByKey(String processDefinitionKey) {
        return ProcessInstantiationBuilderImpl.createProcessInstanceByKey(this.commandExecutor, processDefinitionKey);
    }

    @Override
    public MigrationPlanBuilder createMigrationPlan(String sourceProcessDefinitionId, String targetProcessDefinitionId) {
        return new MigrationPlanBuilderImpl(this.commandExecutor, sourceProcessDefinitionId, targetProcessDefinitionId);
    }

    @Override
    public MigrationPlanExecutionBuilder newMigration(MigrationPlan migrationPlan) {
        return new MigrationPlanExecutionBuilderImpl(this.commandExecutor, migrationPlan);
    }

    @Override
    public ModificationBuilder createModification(String processDefinitionId) {
        return new ModificationBuilderImpl(this.commandExecutor, processDefinitionId);
    }

    @Override
    public RestartProcessInstanceBuilder restartProcessInstances(String processDefinitionId) {
        return new RestartProcessInstanceBuilderImpl(this.commandExecutor, processDefinitionId);
    }

    @Override
    public Incident createIncident(String incidentType, String executionId, String configuration) {
        return this.createIncident(incidentType, executionId, configuration, null);
    }

    @Override
    public Incident createIncident(String incidentType, String executionId, String configuration, String message) {
        return this.commandExecutor.execute(new CreateIncidentCmd(incidentType, executionId, configuration, message));
    }

    @Override
    public void resolveIncident(String incidentId) {
        this.commandExecutor.execute(new ResolveIncidentCmd(incidentId));
    }

    @Override
    public void setAnnotationForIncidentById(String incidentId, String annotation) {
        this.commandExecutor.execute(new SetAnnotationForIncidentCmd(incidentId, annotation));
    }

    @Override
    public void clearAnnotationForIncidentById(String incidentId) {
        this.commandExecutor.execute(new SetAnnotationForIncidentCmd(incidentId, null));
    }

    @Override
    public ConditionEvaluationBuilder createConditionEvaluation() {
        return new ConditionEvaluationBuilderImpl(this.commandExecutor);
    }
}

