/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import org.cibseven.bpm.engine.impl.cfg.CommandChecker;
import org.cibseven.bpm.engine.impl.interceptor.Command;
import org.cibseven.bpm.engine.impl.interceptor.CommandContext;
import org.cibseven.bpm.engine.impl.persistence.entity.PropertyChange;

public class DeleteTaskMetricsCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Date timestamp;

    public DeleteTaskMetricsCmd(Date timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        commandContext.getAuthorizationManager().checkCamundaAdminOrPermission(CommandChecker::checkDeleteTaskMetrics);
        this.writeUserOperationLog(commandContext);
        commandContext.getMeterLogManager().deleteTaskMetricsByTimestamp(this.timestamp);
        return null;
    }

    protected void writeUserOperationLog(CommandContext commandContext) {
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        if (this.timestamp != null) {
            propertyChanges.add(new PropertyChange("timestamp", null, this.timestamp));
        }
        if (propertyChanges.isEmpty()) {
            propertyChanges.add(PropertyChange.EMPTY_CHANGE);
        }
        commandContext.getOperationLogManager().logTaskMetricsOperation("Delete", propertyChanges);
    }
}

