/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.Map;
import org.cibseven.bpm.engine.BadUserRequestException;
import org.cibseven.bpm.engine.exception.NotFoundException;
import org.cibseven.bpm.engine.impl.cfg.CommandChecker;
import org.cibseven.bpm.engine.impl.interceptor.Command;
import org.cibseven.bpm.engine.impl.interceptor.CommandContext;
import org.cibseven.bpm.engine.impl.persistence.entity.TaskEntity;
import org.cibseven.bpm.engine.impl.util.EnsureUtil;

public class HandleTaskEscalationCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected String escalationCode;
    protected Map<String, Object> variables;

    public HandleTaskEscalationCmd(String taskId, String escalationCode) {
        this.taskId = taskId;
        this.escalationCode = escalationCode;
    }

    public HandleTaskEscalationCmd(String taskId, String escalationCode, Map<String, Object> variables) {
        this(taskId, escalationCode);
        this.variables = variables;
    }

    protected void validateInput() {
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "taskId", this.taskId);
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "escalationCode", this.escalationCode);
    }

    @Override
    public Void execute(CommandContext commandContext) {
        this.validateInput();
        TaskEntity task = commandContext.getTaskManager().findTaskById(this.taskId);
        EnsureUtil.ensureNotNull(NotFoundException.class, "Cannot find task with id " + this.taskId, "task", (Object)task);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkTaskWork(task);
        }
        task.escalation(this.escalationCode, this.variables);
        return null;
    }
}

