/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.cibseven.bpm.engine.impl.cfg.CommandChecker;
import org.cibseven.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.cibseven.bpm.engine.impl.context.Context;
import org.cibseven.bpm.engine.impl.interceptor.Command;
import org.cibseven.bpm.engine.impl.interceptor.CommandContext;
import org.cibseven.bpm.engine.impl.persistence.deploy.cache.DeploymentCache;
import org.cibseven.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.cibseven.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.cibseven.bpm.engine.impl.persistence.entity.PropertyChange;
import org.cibseven.bpm.engine.impl.util.EnsureUtil;
import org.cibseven.bpm.engine.runtime.ProcessInstance;
import org.cibseven.bpm.engine.variable.VariableMap;
import org.cibseven.bpm.engine.variable.Variables;

public class SubmitStartFormCmd
implements Command<ProcessInstance>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final String processDefinitionId;
    protected final String businessKey;
    protected VariableMap variables;

    public SubmitStartFormCmd(String processDefinitionId, String businessKey, Map<String, Object> properties) {
        this.processDefinitionId = processDefinitionId;
        this.businessKey = businessKey;
        this.variables = Variables.fromMap(properties);
    }

    @Override
    public ProcessInstance execute(CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        DeploymentCache deploymentCache = processEngineConfiguration.getDeploymentCache();
        ProcessDefinitionEntity processDefinition = deploymentCache.findDeployedProcessDefinitionById(this.processDefinitionId);
        EnsureUtil.ensureNotNull("No process definition found for id = '" + this.processDefinitionId + "'", "processDefinition", (Object)processDefinition);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkCreateProcessInstance(processDefinition);
        }
        ExecutionEntity processInstance = null;
        processInstance = this.businessKey != null ? processDefinition.createProcessInstance(this.businessKey) : processDefinition.createProcessInstance();
        processInstance.startWithFormProperties(this.variables);
        commandContext.getOperationLogManager().logProcessInstanceOperation("Create", processInstance.getId(), processInstance.getProcessDefinitionId(), processInstance.getProcessDefinition().getKey(), Collections.singletonList(PropertyChange.EMPTY_CHANGE));
        return processInstance;
    }
}

