/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.event;

import java.util.Map;
import org.cibseven.bpm.engine.impl.bpmn.behavior.EventSubProcessStartEventActivityBehavior;
import org.cibseven.bpm.engine.impl.bpmn.helper.BpmnProperties;
import org.cibseven.bpm.engine.impl.event.EventHandler;
import org.cibseven.bpm.engine.impl.event.EventType;
import org.cibseven.bpm.engine.impl.interceptor.CommandContext;
import org.cibseven.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.cibseven.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.cibseven.bpm.engine.impl.pvm.process.ActivityImpl;
import org.cibseven.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.cibseven.bpm.engine.impl.util.EnsureUtil;

public class EventHandlerImpl
implements EventHandler {
    private final EventType eventType;

    public EventHandlerImpl(EventType eventType) {
        this.eventType = eventType;
    }

    public void handleIntermediateEvent(EventSubscriptionEntity eventSubscription, Object payload, Object localPayload, Object payloadToTriggeredScope, CommandContext commandContext) {
        ExecutionEntity execution = eventSubscription.getExecution();
        ActivityImpl activity = eventSubscription.getActivity();
        EnsureUtil.ensureNotNull("Error while sending signal for event subscription '" + eventSubscription.getId() + "': no activity associated with event subscription", "activity", (Object)activity);
        if (payload instanceof Map) {
            execution.setVariables((Map<String, ?>)((Map)payload));
        }
        if (localPayload instanceof Map) {
            execution.setVariablesLocal((Map<String, ?>)((Map)localPayload));
        }
        if (payloadToTriggeredScope instanceof Map) {
            if ("intermediateMessageCatch".equals(activity.getProperty(BpmnProperties.TYPE.getName()))) {
                execution.setVariablesLocal((Map<String, ?>)((Map)payloadToTriggeredScope));
            } else {
                ((PvmExecutionImpl)execution).getProcessInstance().setPayloadForTriggeredScope((Map)payloadToTriggeredScope);
            }
        }
        if (activity.equals(((PvmExecutionImpl)execution).getActivity())) {
            execution.signal("signal", null);
        } else {
            if (activity.getActivityBehavior() instanceof EventSubProcessStartEventActivityBehavior) {
                activity = (ActivityImpl)activity.getFlowScope();
            }
            execution.executeEventHandlerActivity(activity);
        }
    }

    @Override
    public void handleEvent(EventSubscriptionEntity eventSubscription, Object payload, Object localPayload, Object payloadToTriggeredScope, String businessKey, CommandContext commandContext) {
        this.handleIntermediateEvent(eventSubscription, payload, localPayload, payloadToTriggeredScope, commandContext);
    }

    @Override
    public String getEventHandlerType() {
        return this.eventType.name();
    }
}

