/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.form.engine;

import java.io.UnsupportedEncodingException;
import org.cibseven.bpm.engine.ProcessEngineException;
import org.cibseven.bpm.engine.delegate.VariableScope;
import org.cibseven.bpm.engine.form.FormData;
import org.cibseven.bpm.engine.form.StartFormData;
import org.cibseven.bpm.engine.form.TaskFormData;
import org.cibseven.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.cibseven.bpm.engine.impl.context.Context;
import org.cibseven.bpm.engine.impl.delegate.ScriptInvocation;
import org.cibseven.bpm.engine.impl.form.engine.FormEngine;
import org.cibseven.bpm.engine.impl.persistence.entity.ResourceEntity;
import org.cibseven.bpm.engine.impl.persistence.entity.TaskEntity;
import org.cibseven.bpm.engine.impl.scripting.ExecutableScript;
import org.cibseven.bpm.engine.impl.scripting.ScriptFactory;
import org.cibseven.bpm.engine.impl.util.EnsureUtil;

public class JuelFormEngine
implements FormEngine {
    @Override
    public String getName() {
        return "juel";
    }

    @Override
    public Object renderStartForm(StartFormData startForm) {
        if (startForm.getFormKey() == null) {
            return null;
        }
        String formTemplateString = this.getFormTemplateString(startForm, startForm.getFormKey());
        return this.executeScript(formTemplateString, null);
    }

    @Override
    public Object renderTaskForm(TaskFormData taskForm) {
        if (taskForm.getFormKey() == null) {
            return null;
        }
        String formTemplateString = this.getFormTemplateString(taskForm, taskForm.getFormKey());
        TaskEntity task = (TaskEntity)taskForm.getTask();
        return this.executeScript(formTemplateString, task.getExecution());
    }

    protected Object executeScript(String scriptSrc, VariableScope scope) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        ScriptFactory scriptFactory = processEngineConfiguration.getScriptFactory();
        ExecutableScript script = scriptFactory.createScriptFromSource("juel", scriptSrc);
        ScriptInvocation invocation = new ScriptInvocation(script, scope);
        try {
            processEngineConfiguration.getDelegateInterceptor().handleInvocation(invocation);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcessEngineException(e);
        }
        return invocation.getInvocationResult();
    }

    protected String getFormTemplateString(FormData formInstance, String formKey) {
        String deploymentId = formInstance.getDeploymentId();
        ResourceEntity resourceStream = Context.getCommandContext().getResourceManager().findResourceByDeploymentIdAndResourceName(deploymentId, formKey);
        EnsureUtil.ensureNotNull("Form with formKey '" + formKey + "' does not exist", "resourceStream", (Object)resourceStream);
        byte[] resourceBytes = resourceStream.getBytes();
        String encoding = "UTF-8";
        String formTemplateString = "";
        try {
            formTemplateString = new String(resourceBytes, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new ProcessEngineException("Unsupported encoding of :" + encoding, e);
        }
        return formTemplateString;
    }
}

