/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.history;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.cibseven.bpm.engine.ProcessEngineException;
import org.cibseven.bpm.engine.impl.interceptor.CommandContext;
import org.cibseven.bpm.engine.impl.persistence.entity.PropertyChange;

public interface SynchronousOperationLogProducer<T> {
    public static final Long SUMMARY_LOG = 1L;
    public static final Long UNLIMITED_LOG = -1L;

    public Map<T, List<PropertyChange>> getPropChangesForOperation(List<T> var1);

    public List<PropertyChange> getSummarizingPropChangesForOperation(List<T> var1);

    public void createOperationLogEntry(CommandContext var1, T var2, List<PropertyChange> var3, boolean var4);

    default public void produceOperationLog(CommandContext commandContext, List<T> results) {
        if (results == null || results.isEmpty()) {
            return;
        }
        long logEntriesPerSyncOperationLimit = commandContext.getProcessEngineConfiguration().getLogEntriesPerSyncOperationLimit();
        if (logEntriesPerSyncOperationLimit == SUMMARY_LOG && results.size() > 1) {
            List<PropertyChange> propChangesForOperation = this.getSummarizingPropChangesForOperation(results);
            if (propChangesForOperation == null) {
                propChangesForOperation = Collections.singletonList(PropertyChange.EMPTY_CHANGE);
            }
            this.createOperationLogEntry(commandContext, results.get(0), propChangesForOperation, true);
        } else {
            Map<T, List<PropertyChange>> propChangesForOperation = this.getPropChangesForOperation(results);
            if (propChangesForOperation == null) {
                propChangesForOperation = results.stream().collect(Collectors.toMap(Function.identity(), result -> Collections.singletonList(PropertyChange.EMPTY_CHANGE)));
            }
            if (logEntriesPerSyncOperationLimit != UNLIMITED_LOG && logEntriesPerSyncOperationLimit < (long)propChangesForOperation.size()) {
                throw new ProcessEngineException("Maximum number of operation log entries for operation type synchronous APIs reached. Configured limit is " + logEntriesPerSyncOperationLimit + " but " + propChangesForOperation.size() + " entities were affected by API call.");
            }
            for (Map.Entry<T, List<PropertyChange>> propChanges : propChangesForOperation.entrySet()) {
                this.createOperationLogEntry(commandContext, propChanges.getKey(), propChanges.getValue(), false);
            }
        }
    }
}

