/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.identity;

import java.util.HashMap;
import java.util.Map;
import org.cibseven.bpm.engine.identity.PasswordPolicyRule;

public class PasswordPolicySpecialCharacterRuleImpl
implements PasswordPolicyRule {
    public static final String SPECIALCHARACTERS = " !\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~";
    public static final String PLACEHOLDER = "PASSWORD_POLICY_SPECIAL";
    protected int minSpecial;

    public PasswordPolicySpecialCharacterRuleImpl(int minSpecial) {
        this.minSpecial = minSpecial;
    }

    @Override
    public String getPlaceholder() {
        return PLACEHOLDER;
    }

    @Override
    public Map<String, String> getParameters() {
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("minSpecial", "" + this.minSpecial);
        return parameter;
    }

    @Override
    public boolean execute(String password) {
        int specialCount = 0;
        char[] cArray = password.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            if (SPECIALCHARACTERS.indexOf(c.charValue()) != -1) {
                ++specialCount;
            }
            if (specialCount < this.minSpecial) continue;
            return true;
        }
        return false;
    }
}

