/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.interceptor;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.cibseven.bpm.application.InvocationContext;
import org.cibseven.bpm.application.ProcessApplicationReference;
import org.cibseven.bpm.engine.ProcessEngineException;
import org.cibseven.bpm.engine.impl.ProcessEngineLogger;
import org.cibseven.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.cibseven.bpm.engine.impl.cmd.CommandLogger;
import org.cibseven.bpm.engine.impl.context.Context;
import org.cibseven.bpm.engine.impl.context.ProcessApplicationContextUtil;
import org.cibseven.bpm.engine.impl.interceptor.AtomicOperationInvocation;
import org.cibseven.bpm.engine.impl.interceptor.BpmnStackTrace;
import org.cibseven.bpm.engine.impl.interceptor.Command;
import org.cibseven.bpm.engine.impl.interceptor.ProcessDataContext;
import org.cibseven.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.cibseven.bpm.engine.impl.pvm.runtime.AtomicOperation;

public class CommandInvocationContext {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected Throwable throwable;
    protected Command<?> command;
    protected boolean isExecuting = false;
    protected List<AtomicOperationInvocation> queuedInvocations = new ArrayList<AtomicOperationInvocation>();
    protected BpmnStackTrace bpmnStackTrace = new BpmnStackTrace();
    protected ProcessDataContext processDataContext;

    public CommandInvocationContext(Command<?> command, ProcessEngineConfigurationImpl configuration, boolean isOuterCommand) {
        this.command = command;
        this.processDataContext = new ProcessDataContext(configuration, false, isOuterCommand);
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public Command<?> getCommand() {
        return this.command;
    }

    public void trySetThrowable(Throwable t) {
        if (this.throwable == null) {
            this.throwable = t;
        } else {
            LOG.maskedExceptionInCommandContext(this.throwable);
        }
    }

    public void performOperation(AtomicOperation executionOperation, ExecutionEntity execution) {
        this.performOperation(executionOperation, execution, false);
    }

    public void performOperationAsync(AtomicOperation executionOperation, ExecutionEntity execution) {
        this.performOperation(executionOperation, execution, true);
    }

    public void performOperation(AtomicOperation executionOperation, ExecutionEntity execution, boolean performAsync) {
        AtomicOperationInvocation invocation = new AtomicOperationInvocation(executionOperation, execution, performAsync);
        this.queuedInvocations.add(0, invocation);
        this.performNext();
    }

    protected void performNext() {
        AtomicOperationInvocation nextInvocation = this.queuedInvocations.get(0);
        if (nextInvocation.operation.isAsyncCapable() && this.isExecuting) {
            return;
        }
        ProcessApplicationReference targetProcessApplication = this.getTargetProcessApplication(nextInvocation.execution);
        if (this.requiresContextSwitch(targetProcessApplication)) {
            Context.executeWithinProcessApplication(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    CommandInvocationContext.this.performNext();
                    return null;
                }
            }, targetProcessApplication, new InvocationContext(nextInvocation.execution));
        } else if (!nextInvocation.operation.isAsyncCapable()) {
            this.invokeNext();
        } else {
            try {
                this.isExecuting = true;
                while (!this.queuedInvocations.isEmpty()) {
                    this.invokeNext();
                }
            }
            finally {
                this.isExecuting = false;
            }
        }
    }

    protected void invokeNext() {
        AtomicOperationInvocation invocation = this.queuedInvocations.remove(0);
        try {
            invocation.execute(this.bpmnStackTrace, this.processDataContext);
        }
        catch (RuntimeException e) {
            this.bpmnStackTrace.printStackTrace(Context.getProcessEngineConfiguration().isBpmnStacktraceVerbose());
            throw e;
        }
    }

    protected boolean requiresContextSwitch(ProcessApplicationReference processApplicationReference) {
        return ProcessApplicationContextUtil.requiresContextSwitch(processApplicationReference);
    }

    protected ProcessApplicationReference getTargetProcessApplication(ExecutionEntity execution) {
        return ProcessApplicationContextUtil.getTargetProcessApplication(execution);
    }

    public void rethrow() {
        if (this.throwable != null) {
            if (this.throwable instanceof Error) {
                throw (Error)this.throwable;
            }
            if (this.throwable instanceof RuntimeException) {
                throw (RuntimeException)this.throwable;
            }
            throw new ProcessEngineException("exception while executing command " + String.valueOf(this.command), this.throwable);
        }
    }

    public ProcessDataContext getProcessDataContext() {
        return this.processDataContext;
    }
}

