/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.jobexecutor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cibseven.bpm.engine.impl.jobexecutor.AcquiredJobs;
import org.cibseven.bpm.engine.impl.util.CollectionUtil;

public class JobAcquisitionContext {
    protected Map<String, List<List<String>>> rejectedJobBatchesByEngine = new HashMap<String, List<List<String>>>();
    protected Map<String, AcquiredJobs> acquiredJobsByEngine;
    protected Map<String, List<List<String>>> additionalJobBatchesByEngine = new HashMap<String, List<List<String>>>();
    protected Exception acquisitionException;
    protected long acquisitionTime;
    protected boolean isJobAdded;

    public JobAcquisitionContext() {
        this.acquiredJobsByEngine = new HashMap<String, AcquiredJobs>();
    }

    public void submitRejectedBatch(String engineName, List<String> jobIds) {
        CollectionUtil.addToMapOfLists(this.rejectedJobBatchesByEngine, engineName, jobIds);
    }

    public void submitAcquiredJobs(String engineName, AcquiredJobs acquiredJobs) {
        this.acquiredJobsByEngine.put(engineName, acquiredJobs);
    }

    public void submitAdditionalJobBatch(String engineName, List<String> jobIds) {
        CollectionUtil.addToMapOfLists(this.additionalJobBatchesByEngine, engineName, jobIds);
    }

    public void reset() {
        this.additionalJobBatchesByEngine.clear();
        this.additionalJobBatchesByEngine.putAll(this.rejectedJobBatchesByEngine);
        this.rejectedJobBatchesByEngine.clear();
        this.acquiredJobsByEngine.clear();
        this.acquisitionException = null;
        this.acquisitionTime = 0L;
        this.isJobAdded = false;
    }

    public boolean areAllEnginesIdle() {
        for (AcquiredJobs acquiredJobs : this.acquiredJobsByEngine.values()) {
            int jobsAcquired = acquiredJobs.getJobIdBatches().size() + acquiredJobs.getNumberOfJobsFailedToLock();
            if (jobsAcquired < acquiredJobs.getNumberOfJobsAttemptedToAcquire()) continue;
            return false;
        }
        return true;
    }

    public boolean hasJobAcquisitionLockFailureOccurred() {
        for (AcquiredJobs acquiredJobs : this.acquiredJobsByEngine.values()) {
            if (acquiredJobs.getNumberOfJobsFailedToLock() <= 0) continue;
            return true;
        }
        return false;
    }

    public void setAcquisitionTime(long acquisitionTime) {
        this.acquisitionTime = acquisitionTime;
    }

    public long getAcquisitionTime() {
        return this.acquisitionTime;
    }

    public Map<String, AcquiredJobs> getAcquiredJobsByEngine() {
        return this.acquiredJobsByEngine;
    }

    public Map<String, List<List<String>>> getRejectedJobsByEngine() {
        return this.rejectedJobBatchesByEngine;
    }

    public Map<String, List<List<String>>> getAdditionalJobsByEngine() {
        return this.additionalJobBatchesByEngine;
    }

    public void setAcquisitionException(Exception e) {
        this.acquisitionException = e;
    }

    public Exception getAcquisitionException() {
        return this.acquisitionException;
    }

    public void setJobAdded(boolean isJobAdded) {
        this.isJobAdded = isJobAdded;
    }

    public boolean isJobAdded() {
        return this.isJobAdded;
    }
}

