/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.jobexecutor;

import java.util.List;
import org.cibseven.bpm.container.ExecutorService;
import org.cibseven.bpm.container.RuntimeContainerDelegate;
import org.cibseven.bpm.container.impl.jmx.services.JmxManagedThreadPool;
import org.cibseven.bpm.engine.ProcessEngineException;
import org.cibseven.bpm.engine.impl.ProcessEngineImpl;
import org.cibseven.bpm.engine.impl.jobexecutor.JobExecutor;

public class RuntimeContainerJobExecutor
extends JobExecutor {
    @Override
    protected void startExecutingJobs() {
        RuntimeContainerDelegate runtimeContainerDelegate = this.getRuntimeContainerDelegate();
        if (!runtimeContainerDelegate.getExecutorService().schedule(this.acquireJobsRunnable, true)) {
            throw new ProcessEngineException("Could not schedule AcquireJobsRunnable for execution.");
        }
    }

    @Override
    protected void stopExecutingJobs() {
    }

    @Override
    public void executeJobs(List<String> jobIds, ProcessEngineImpl processEngine) {
        Runnable executeJobsRunnable;
        RuntimeContainerDelegate runtimeContainerDelegate = this.getRuntimeContainerDelegate();
        ExecutorService executorService = runtimeContainerDelegate.getExecutorService();
        if (!executorService.schedule(executeJobsRunnable = this.getExecuteJobsRunnable(jobIds, processEngine), false)) {
            this.logRejectedExecution(processEngine, jobIds.size());
            this.rejectedJobsHandler.jobsRejected(jobIds, processEngine, this);
        }
        if (executorService instanceof JmxManagedThreadPool) {
            int totalQueueCapacity = this.calculateTotalQueueCapacity(((JmxManagedThreadPool)executorService).getQueueCount(), ((JmxManagedThreadPool)executorService).getQueueAddlCapacity());
            this.logJobExecutionInfo(processEngine, ((JmxManagedThreadPool)executorService).getQueueCount(), totalQueueCapacity, ((JmxManagedThreadPool)executorService).getMaximumPoolSize(), ((JmxManagedThreadPool)executorService).getActiveCount());
        }
    }

    protected RuntimeContainerDelegate getRuntimeContainerDelegate() {
        return RuntimeContainerDelegate.INSTANCE.get();
    }

    @Override
    public Runnable getExecuteJobsRunnable(List<String> jobIds, ProcessEngineImpl processEngine) {
        RuntimeContainerDelegate runtimeContainerDelegate = this.getRuntimeContainerDelegate();
        ExecutorService executorService = runtimeContainerDelegate.getExecutorService();
        return executorService.getExecuteJobsRunnable(jobIds, processEngine);
    }
}

