/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.json;

import camundajar.impl.com.google.gson.JsonObject;
import org.cibseven.bpm.engine.impl.json.JsonObjectConverter;
import org.cibseven.bpm.engine.impl.json.MigrationInstructionJsonConverter;
import org.cibseven.bpm.engine.impl.migration.MigrationPlanImpl;
import org.cibseven.bpm.engine.impl.util.JsonUtil;
import org.cibseven.bpm.engine.migration.MigrationPlan;

public class MigrationPlanJsonConverter
extends JsonObjectConverter<MigrationPlan> {
    public static final MigrationPlanJsonConverter INSTANCE = new MigrationPlanJsonConverter();
    public static final String SOURCE_PROCESS_DEFINITION_ID = "sourceProcessDefinitionId";
    public static final String TARGET_PROCESS_DEFINITION_ID = "targetProcessDefinitionId";
    public static final String INSTRUCTIONS = "instructions";

    @Override
    public JsonObject toJsonObject(MigrationPlan migrationPlan) {
        JsonObject json = JsonUtil.createObject();
        JsonUtil.addField(json, SOURCE_PROCESS_DEFINITION_ID, migrationPlan.getSourceProcessDefinitionId());
        JsonUtil.addField(json, TARGET_PROCESS_DEFINITION_ID, migrationPlan.getTargetProcessDefinitionId());
        JsonUtil.addListField(json, INSTRUCTIONS, MigrationInstructionJsonConverter.INSTANCE, migrationPlan.getInstructions());
        return json;
    }

    @Override
    public MigrationPlan toObject(JsonObject json) {
        MigrationPlanImpl migrationPlan = new MigrationPlanImpl(JsonUtil.getString(json, SOURCE_PROCESS_DEFINITION_ID), JsonUtil.getString(json, TARGET_PROCESS_DEFINITION_ID));
        migrationPlan.setInstructions(JsonUtil.asList(JsonUtil.getArray(json, INSTRUCTIONS), MigrationInstructionJsonConverter.INSTANCE));
        return migrationPlan;
    }
}

