/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.migration.validation.instruction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.cibseven.bpm.engine.impl.migration.validation.instruction.MigrationInstructionValidationReportImpl;
import org.cibseven.bpm.engine.impl.migration.validation.instruction.MigrationInstructionValidator;
import org.cibseven.bpm.engine.impl.migration.validation.instruction.ValidatingMigrationInstruction;
import org.cibseven.bpm.engine.impl.pvm.process.ScopeImpl;
import org.cibseven.bpm.engine.impl.util.CollectionUtil;
import org.cibseven.bpm.engine.migration.MigrationInstruction;

public class ValidatingMigrationInstructions {
    protected Collection<ValidatingMigrationInstruction> instructions;
    protected Map<ScopeImpl, List<ValidatingMigrationInstruction>> instructionsBySourceScope;
    protected Map<ScopeImpl, List<ValidatingMigrationInstruction>> instructionsByTargetScope;

    public ValidatingMigrationInstructions(Collection<ValidatingMigrationInstruction> instructions) {
        this.instructions = instructions;
        this.instructionsBySourceScope = new HashMap<ScopeImpl, List<ValidatingMigrationInstruction>>();
        this.instructionsByTargetScope = new HashMap<ScopeImpl, List<ValidatingMigrationInstruction>>();
        for (ValidatingMigrationInstruction instruction : instructions) {
            this.indexInstruction(instruction);
        }
    }

    public ValidatingMigrationInstructions() {
        this(new HashSet<ValidatingMigrationInstruction>());
    }

    public void addInstruction(ValidatingMigrationInstruction instruction) {
        this.instructions.add(instruction);
        this.indexInstruction(instruction);
    }

    public void addAll(List<ValidatingMigrationInstruction> instructions) {
        for (ValidatingMigrationInstruction instruction : instructions) {
            this.addInstruction(instruction);
        }
    }

    protected void indexInstruction(ValidatingMigrationInstruction instruction) {
        CollectionUtil.addToMapOfLists(this.instructionsBySourceScope, instruction.getSourceActivity(), instruction);
        CollectionUtil.addToMapOfLists(this.instructionsByTargetScope, instruction.getTargetActivity(), instruction);
    }

    public List<ValidatingMigrationInstruction> getInstructions() {
        return new ArrayList<ValidatingMigrationInstruction>(this.instructions);
    }

    public List<ValidatingMigrationInstruction> getInstructionsBySourceScope(ScopeImpl scope) {
        List<ValidatingMigrationInstruction> instructions = this.instructionsBySourceScope.get(scope);
        if (instructions == null) {
            return Collections.emptyList();
        }
        return instructions;
    }

    public List<ValidatingMigrationInstruction> getInstructionsByTargetScope(ScopeImpl scope) {
        List<ValidatingMigrationInstruction> instructions = this.instructionsByTargetScope.get(scope);
        if (instructions == null) {
            return Collections.emptyList();
        }
        return instructions;
    }

    public void filterWith(List<MigrationInstructionValidator> validators) {
        ArrayList<ValidatingMigrationInstruction> validInstructions = new ArrayList<ValidatingMigrationInstruction>();
        for (ValidatingMigrationInstruction instruction : this.instructions) {
            if (!this.isValidInstruction(instruction, this, validators)) continue;
            validInstructions.add(instruction);
        }
        this.instructionsBySourceScope.clear();
        this.instructionsByTargetScope.clear();
        this.instructions.clear();
        for (ValidatingMigrationInstruction validInstruction : validInstructions) {
            this.addInstruction(validInstruction);
        }
    }

    public List<MigrationInstruction> asMigrationInstructions() {
        ArrayList<MigrationInstruction> instructions = new ArrayList<MigrationInstruction>();
        for (ValidatingMigrationInstruction instruction : this.instructions) {
            instructions.add(instruction.toMigrationInstruction());
        }
        return instructions;
    }

    public boolean contains(ValidatingMigrationInstruction instruction) {
        return this.instructions.contains(instruction);
    }

    public boolean containsInstructionForSourceScope(ScopeImpl sourceScope) {
        return this.instructionsBySourceScope.containsKey(sourceScope);
    }

    protected boolean isValidInstruction(ValidatingMigrationInstruction instruction, ValidatingMigrationInstructions instructions, List<MigrationInstructionValidator> migrationInstructionValidators) {
        return !this.validateInstruction(instruction, instructions, migrationInstructionValidators).hasFailures();
    }

    protected MigrationInstructionValidationReportImpl validateInstruction(ValidatingMigrationInstruction instruction, ValidatingMigrationInstructions instructions, List<MigrationInstructionValidator> migrationInstructionValidators) {
        MigrationInstructionValidationReportImpl validationReport = new MigrationInstructionValidationReportImpl(instruction.toMigrationInstruction());
        for (MigrationInstructionValidator migrationInstructionValidator : migrationInstructionValidators) {
            migrationInstructionValidator.validate(instruction, instructions, validationReport);
        }
        return validationReport;
    }
}

