/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.persistence.entity;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cibseven.bpm.engine.history.HistoricVariableInstance;
import org.cibseven.bpm.engine.history.HistoricVariableInstanceQuery;
import org.cibseven.bpm.engine.impl.HistoricVariableInstanceQueryImpl;
import org.cibseven.bpm.engine.impl.Page;
import org.cibseven.bpm.engine.impl.db.ListQueryParameterObject;
import org.cibseven.bpm.engine.impl.db.entitymanager.operation.DbOperation;
import org.cibseven.bpm.engine.impl.persistence.AbstractHistoricManager;
import org.cibseven.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.cibseven.bpm.engine.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.cibseven.bpm.engine.impl.util.EnsureUtil;

public class HistoricVariableInstanceManager
extends AbstractHistoricManager {
    public void deleteHistoricVariableInstanceByVariableInstanceId(String historicVariableInstanceId) {
        HistoricVariableInstanceEntity historicVariableInstance;
        if (this.isHistoryEnabled() && (historicVariableInstance = this.findHistoricVariableInstanceByVariableInstanceId(historicVariableInstanceId)) != null) {
            historicVariableInstance.delete();
        }
    }

    public void deleteHistoricVariableInstanceByProcessInstanceIds(List<String> historicProcessInstanceIds) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processInstanceIds", historicProcessInstanceIds);
        this.deleteHistoricVariableInstances(parameters);
    }

    public void deleteHistoricVariableInstancesByTaskProcessInstanceIds(List<String> historicProcessInstanceIds) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("taskProcessInstanceIds", historicProcessInstanceIds);
        this.deleteHistoricVariableInstances(parameters);
    }

    public void deleteHistoricVariableInstanceByCaseInstanceId(String historicCaseInstanceId) {
        this.deleteHistoricVariableInstancesByProcessCaseInstanceId(null, historicCaseInstanceId);
    }

    public void deleteHistoricVariableInstancesByCaseInstanceIds(List<String> historicCaseInstanceIds) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("caseInstanceIds", historicCaseInstanceIds);
        this.deleteHistoricVariableInstances(parameters);
    }

    protected void deleteHistoricVariableInstances(Map<String, Object> parameters) {
        this.getDbEntityManager().deletePreserveOrder(ByteArrayEntity.class, "deleteHistoricVariableInstanceByteArraysByIds", parameters);
        this.getDbEntityManager().deletePreserveOrder(HistoricVariableInstanceEntity.class, "deleteHistoricVariableInstanceByIds", parameters);
    }

    protected void deleteHistoricVariableInstancesByProcessCaseInstanceId(String historicProcessInstanceId, String historicCaseInstanceId) {
        EnsureUtil.ensureOnlyOneNotNull("Only the process instance or case instance id should be set", historicProcessInstanceId, historicCaseInstanceId);
        if (this.isHistoryEnabled()) {
            List<HistoricVariableInstance> historicVariableInstances = historicProcessInstanceId != null ? this.findHistoricVariableInstancesByProcessInstanceId(historicProcessInstanceId) : this.findHistoricVariableInstancesByCaseInstanceId(historicCaseInstanceId);
            for (HistoricVariableInstance historicVariableInstance : historicVariableInstances) {
                ((HistoricVariableInstanceEntity)historicVariableInstance).delete();
            }
            List<HistoricVariableInstanceEntity> cachedHistoricVariableInstances = this.getDbEntityManager().getCachedEntitiesByType(HistoricVariableInstanceEntity.class);
            for (HistoricVariableInstanceEntity historicVariableInstance : cachedHistoricVariableInstances) {
                if ((historicProcessInstanceId == null || !historicProcessInstanceId.equals(historicVariableInstance.getProcessInstanceId())) && (historicCaseInstanceId == null || !historicCaseInstanceId.equals(historicVariableInstance.getCaseInstanceId()))) continue;
                historicVariableInstance.delete();
            }
        }
    }

    public List<HistoricVariableInstance> findHistoricVariableInstancesByProcessInstanceId(String processInstanceId) {
        return this.getDbEntityManager().selectList("selectHistoricVariablesByProcessInstanceId", processInstanceId);
    }

    public List<HistoricVariableInstance> findHistoricVariableInstancesByCaseInstanceId(String caseInstanceId) {
        return this.getDbEntityManager().selectList("selectHistoricVariablesByCaseInstanceId", caseInstanceId);
    }

    public long findHistoricVariableInstanceCountByQueryCriteria(HistoricVariableInstanceQueryImpl historicProcessVariableQuery) {
        this.configureQuery(historicProcessVariableQuery);
        return (Long)this.getDbEntityManager().selectOne("selectHistoricVariableInstanceCountByQueryCriteria", historicProcessVariableQuery);
    }

    public List<HistoricVariableInstance> findHistoricVariableInstancesByQueryCriteria(HistoricVariableInstanceQueryImpl historicProcessVariableQuery, Page page) {
        this.configureQuery(historicProcessVariableQuery);
        return this.getDbEntityManager().selectList("selectHistoricVariableInstanceByQueryCriteria", historicProcessVariableQuery, page);
    }

    public HistoricVariableInstanceEntity findHistoricVariableInstanceByVariableInstanceId(String variableInstanceId) {
        return (HistoricVariableInstanceEntity)this.getDbEntityManager().selectOne("selectHistoricVariableInstanceByVariableInstanceId", variableInstanceId);
    }

    public void deleteHistoricVariableInstancesByTaskId(String taskId) {
        if (this.isHistoryEnabled()) {
            HistoricVariableInstanceQuery historicProcessVariableQuery = new HistoricVariableInstanceQueryImpl().taskIdIn(taskId);
            List historicProcessVariables = historicProcessVariableQuery.list();
            for (HistoricVariableInstance historicProcessVariable : historicProcessVariables) {
                ((HistoricVariableInstanceEntity)historicProcessVariable).delete();
            }
        }
    }

    public DbOperation addRemovalTimeToVariableInstancesByRootProcessInstanceId(String rootProcessInstanceId, Date removalTime, Integer batchSize) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("rootProcessInstanceId", rootProcessInstanceId);
        parameters.put("removalTime", removalTime);
        parameters.put("maxResults", batchSize);
        return this.getDbEntityManager().updatePreserveOrder(HistoricVariableInstanceEntity.class, "updateHistoricVariableInstancesByRootProcessInstanceId", parameters);
    }

    public DbOperation addRemovalTimeToVariableInstancesByProcessInstanceId(String processInstanceId, Date removalTime, Integer batchSize) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processInstanceId", processInstanceId);
        parameters.put("removalTime", removalTime);
        parameters.put("maxResults", batchSize);
        return this.getDbEntityManager().updatePreserveOrder(HistoricVariableInstanceEntity.class, "updateHistoricVariableInstancesByProcessInstanceId", parameters);
    }

    public List<HistoricVariableInstance> findHistoricVariableInstancesByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbEntityManager().selectListWithRawParameter("selectHistoricVariableInstanceByNativeQuery", parameterMap, firstResult, maxResults);
    }

    public long findHistoricVariableInstanceCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbEntityManager().selectOne("selectHistoricVariableInstanceCountByNativeQuery", parameterMap);
    }

    protected void configureQuery(HistoricVariableInstanceQueryImpl query) {
        this.getAuthorizationManager().configureHistoricVariableInstanceQuery(query);
        this.getTenantManager().configureQuery(query);
    }

    public DbOperation deleteHistoricVariableInstancesByRemovalTime(Date removalTime, int minuteFrom, int minuteTo, int batchSize) {
        HashMap<String, Comparable<Date>> parameters = new HashMap<String, Comparable<Date>>();
        parameters.put("removalTime", removalTime);
        if (minuteTo - minuteFrom + 1 < 60) {
            parameters.put("minuteFrom", Integer.valueOf(minuteFrom));
            parameters.put("minuteTo", Integer.valueOf(minuteTo));
        }
        parameters.put("batchSize", Integer.valueOf(batchSize));
        return this.getDbEntityManager().deletePreserveOrder(HistoricVariableInstanceEntity.class, "deleteHistoricVariableInstancesByRemovalTime", new ListQueryParameterObject(parameters, 0, batchSize));
    }
}

