/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.persistence.entity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cibseven.bpm.engine.impl.persistence.AbstractManager;
import org.cibseven.bpm.engine.impl.persistence.entity.PropertyEntity;
import org.cibseven.bpm.engine.impl.persistence.entity.ResourceEntity;

public class ResourceManager
extends AbstractManager {
    public void insertResource(ResourceEntity resource) {
        this.getDbEntityManager().insert(resource);
    }

    public void deleteResourcesByDeploymentId(String deploymentId) {
        this.getDbEntityManager().delete(ResourceEntity.class, "deleteResourcesByDeploymentId", deploymentId);
    }

    public ResourceEntity findResourceByDeploymentIdAndResourceName(String deploymentId, String resourceName) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("deploymentId", deploymentId);
        params.put("resourceName", resourceName);
        return (ResourceEntity)this.getDbEntityManager().selectOne("selectResourceByDeploymentIdAndResourceName", params);
    }

    public List<ResourceEntity> findResourceByDeploymentIdAndResourceNames(String deploymentId, String ... resourceNames) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("deploymentId", deploymentId);
        params.put("resourceNames", resourceNames);
        return this.getDbEntityManager().selectList("selectResourceByDeploymentIdAndResourceNames", params);
    }

    public ResourceEntity findResourceByDeploymentIdAndResourceId(String deploymentId, String resourceId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("deploymentId", deploymentId);
        params.put("resourceId", resourceId);
        return (ResourceEntity)this.getDbEntityManager().selectOne("selectResourceByDeploymentIdAndResourceId", params);
    }

    public List<ResourceEntity> findResourceByDeploymentIdAndResourceIds(String deploymentId, String ... resourceIds) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("deploymentId", deploymentId);
        params.put("resourceIds", resourceIds);
        return this.getDbEntityManager().selectList("selectResourceByDeploymentIdAndResourceIds", params);
    }

    public List<ResourceEntity> findResourcesByDeploymentId(String deploymentId) {
        return this.getDbEntityManager().selectList("selectResourcesByDeploymentId", deploymentId);
    }

    public Map<String, ResourceEntity> findLatestResourcesByDeploymentName(String deploymentName, Set<String> resourcesToFind, String source, String tenantId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("deploymentName", deploymentName);
        params.put("resourcesToFind", resourcesToFind);
        params.put("source", source);
        params.put("tenantId", tenantId);
        List resources = this.getDbEntityManager().selectList("selectLatestResourcesByDeploymentName", params);
        HashMap<String, ResourceEntity> existingResourcesByName = new HashMap<String, ResourceEntity>();
        for (ResourceEntity existingResource : resources) {
            existingResourcesByName.put(existingResource.getName(), existingResource);
        }
        return existingResourcesByName;
    }

    public ResourceEntity findLicenseKeyResource() {
        PropertyEntity licenseProperty = (PropertyEntity)this.getDbEntityManager().selectOne("selectProperty", "camunda-license-key-id");
        return licenseProperty == null ? null : (ResourceEntity)this.getDbEntityManager().selectOne("selectResourceById", licenseProperty.value);
    }
}

