/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.persistence.entity;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.cibseven.bpm.engine.impl.ProcessEngineLogger;
import org.cibseven.bpm.engine.impl.calendar.BusinessCalendar;
import org.cibseven.bpm.engine.impl.calendar.CycleBusinessCalendar;
import org.cibseven.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.cibseven.bpm.engine.impl.cfg.TransactionState;
import org.cibseven.bpm.engine.impl.context.Context;
import org.cibseven.bpm.engine.impl.interceptor.CommandContext;
import org.cibseven.bpm.engine.impl.interceptor.CommandExecutor;
import org.cibseven.bpm.engine.impl.jobexecutor.RepeatingFailedJobListener;
import org.cibseven.bpm.engine.impl.jobexecutor.TimerDeclarationImpl;
import org.cibseven.bpm.engine.impl.jobexecutor.TimerDeclarationType;
import org.cibseven.bpm.engine.impl.jobexecutor.TimerEventJobHandler;
import org.cibseven.bpm.engine.impl.persistence.entity.JobEntity;
import org.cibseven.bpm.engine.impl.util.ClockUtil;

public class TimerEntity
extends JobEntity {
    protected static final String CYCLE_EXPRESSION_START_TYPE_1 = String.valueOf((Object)TimerDeclarationType.CYCLE) + ": #";
    protected static final String CYCLE_EXPRESSION_START_TYPE_2 = String.valueOf((Object)TimerDeclarationType.CYCLE) + ": $";
    public static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    public static final String TYPE = "timer";
    private static final long serialVersionUID = 1L;
    protected String repeat;
    protected long repeatOffset;

    public TimerEntity() {
    }

    public TimerEntity(TimerDeclarationImpl timerDeclaration) {
        this.repeat = timerDeclaration.getRepeat();
    }

    protected TimerEntity(TimerEntity te) {
        this.jobHandlerConfiguration = te.jobHandlerConfiguration;
        this.jobHandlerType = te.jobHandlerType;
        this.isExclusive = te.isExclusive;
        this.repeat = te.repeat;
        this.repeatOffset = te.repeatOffset;
        this.retries = te.retries;
        this.executionId = te.executionId;
        this.processInstanceId = te.processInstanceId;
        this.jobDefinitionId = te.jobDefinitionId;
        this.suspensionState = te.suspensionState;
        this.deploymentId = te.deploymentId;
        this.processDefinitionId = te.processDefinitionId;
        this.processDefinitionKey = te.processDefinitionKey;
        this.tenantId = te.tenantId;
        this.priority = te.priority;
    }

    @Override
    protected void preExecute(CommandContext commandContext) {
        if (this.getJobHandler() instanceof TimerEventJobHandler) {
            TimerEventJobHandler.TimerJobConfiguration configuration = (TimerEventJobHandler.TimerJobConfiguration)this.getJobHandlerConfiguration();
            if (this.repeat != null && !configuration.isFollowUpJobCreated()) {
                Date newDueDate;
                String expressionValue;
                if (this.isReevaluateTimeCycleWhenDue(commandContext) && this.isCycleExpression() && (expressionValue = this.parseExpression(commandContext)) != null) {
                    this.repeat = this.adjustRepeatBasedOnNewExpression(expressionValue);
                }
                if ((newDueDate = this.calculateNewDueDate()) != null) {
                    ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
                    CommandExecutor commandExecutor = processEngineConfiguration.getCommandExecutorTxRequiresNew();
                    RepeatingFailedJobListener listener = this.createRepeatingFailedJobListener(commandExecutor);
                    commandContext.getTransactionContext().addTransactionListener(TransactionState.ROLLED_BACK, listener);
                    this.createNewTimerJob(newDueDate);
                }
            }
        }
    }

    protected String parseExpression(CommandContext commandContext) {
        String expressionValue = null;
        String expression = this.jobDefinition.getJobConfiguration().substring(CYCLE_EXPRESSION_START_TYPE_1.length() - 1);
        try {
            expressionValue = commandContext.getProcessEngineConfiguration().getExpressionManager().createExpression(expression).getValue(this.execution).toString();
        }
        catch (Exception e) {
            throw ProcessEngineLogger.UTIL_LOGGER.exceptionWhileParsingCycleExpresison(expression, e);
        }
        return expressionValue;
    }

    protected boolean isReevaluateTimeCycleWhenDue(CommandContext commandContext) {
        return commandContext.getProcessEngineConfiguration().isReevaluateTimeCycleWhenDue();
    }

    protected boolean isCycleExpression() {
        String jobConfiguration = this.jobDefinition.getJobConfiguration();
        return jobConfiguration.contains(CYCLE_EXPRESSION_START_TYPE_1) || jobConfiguration.contains(CYCLE_EXPRESSION_START_TYPE_2);
    }

    protected String adjustRepeatBasedOnNewExpression(String expressionValue) {
        String changedRepeat = expressionValue.startsWith("R") ? (this.repeat.startsWith("R") ? (this.isSameRepeatCycle(expressionValue) ? this.repeat : TimerEntity.replaceRepeatCycleAndDate(expressionValue)) : TimerEntity.replaceRepeatCycleAndDate(expressionValue)) : expressionValue;
        return changedRepeat;
    }

    protected boolean isSameRepeatCycle(String expressionValue) {
        String[] currentRepeat = this.repeat.split("/");
        String[] newRepeat = expressionValue.split("/");
        if (currentRepeat.length == 3 && newRepeat.length == 2) {
            return currentRepeat[0].equals(newRepeat[0]) && currentRepeat[2].equals(newRepeat[1]);
        }
        if (currentRepeat.length == 3 && newRepeat.length == 3) {
            return this.repeat.equals(expressionValue);
        }
        return true;
    }

    public static String replaceRepeatCycleAndDate(String repeatExpression) {
        if (repeatExpression.split("/").length == 2) {
            return repeatExpression.replace("/", "/" + SIMPLE_DATE_FORMAT.format(ClockUtil.getCurrentTime()) + "/");
        }
        return repeatExpression;
    }

    protected RepeatingFailedJobListener createRepeatingFailedJobListener(CommandExecutor commandExecutor) {
        return new RepeatingFailedJobListener(commandExecutor, this.getId());
    }

    public void createNewTimerJob(Date dueDate) {
        TimerEntity newTimer = new TimerEntity(this);
        newTimer.setDuedate(dueDate);
        Context.getCommandContext().getJobManager().schedule(newTimer);
    }

    public Date calculateNewDueDate() {
        BusinessCalendar businessCalendar = Context.getProcessEngineConfiguration().getBusinessCalendarManager().getBusinessCalendar(CycleBusinessCalendar.NAME);
        return ((CycleBusinessCalendar)businessCalendar).resolveDuedate(this.repeat, null, this.repeatOffset);
    }

    public String getRepeat() {
        return this.repeat;
    }

    public void setRepeat(String repeat) {
        this.repeat = repeat;
    }

    public long getRepeatOffset() {
        return this.repeatOffset;
    }

    public void setRepeatOffset(long repeatOffset) {
        this.repeatOffset = repeatOffset;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public Object getPersistentState() {
        HashMap persistentState = (HashMap)super.getPersistentState();
        persistentState.put("repeat", this.repeat);
        return persistentState;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[repeat=" + this.repeat + ", id=" + this.id + ", revision=" + this.revision + ", duedate=" + String.valueOf(this.duedate) + ", repeatOffset=" + this.repeatOffset + ", lockOwner=" + this.lockOwner + ", lockExpirationTime=" + String.valueOf(this.lockExpirationTime) + ", executionId=" + this.executionId + ", processInstanceId=" + this.processInstanceId + ", isExclusive=" + this.isExclusive + ", retries=" + this.retries + ", jobHandlerType=" + this.jobHandlerType + ", jobHandlerConfiguration=" + this.jobHandlerConfiguration + ", exceptionByteArray=" + String.valueOf(this.exceptionByteArray) + ", exceptionByteArrayId=" + this.exceptionByteArrayId + ", exceptionMessage=" + this.exceptionMessage + ", deploymentId=" + this.deploymentId + "]";
    }
}

