/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.pvm.runtime.operation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.cibseven.bpm.engine.ProcessEngineException;
import org.cibseven.bpm.engine.impl.ProcessEngineLogger;
import org.cibseven.bpm.engine.impl.pvm.PvmLogger;
import org.cibseven.bpm.engine.impl.pvm.PvmTransition;
import org.cibseven.bpm.engine.impl.pvm.process.ActivityImpl;
import org.cibseven.bpm.engine.impl.pvm.runtime.LegacyBehavior;
import org.cibseven.bpm.engine.impl.pvm.runtime.OutgoingExecution;
import org.cibseven.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.cibseven.bpm.engine.impl.pvm.runtime.operation.PvmAtomicOperation;

public class PvmAtomicOperationTransitionDestroyScope
implements PvmAtomicOperation {
    private static final PvmLogger LOG = ProcessEngineLogger.PVM_LOGGER;

    @Override
    public boolean isAsync(PvmExecutionImpl instance) {
        return false;
    }

    @Override
    public boolean isAsyncCapable() {
        return false;
    }

    @Override
    public void execute(PvmExecutionImpl execution) {
        PvmExecutionImpl propagatingExecution = execution;
        ActivityImpl activity = execution.getActivity();
        List<PvmTransition> transitionsToTake = execution.getTransitionsToTake();
        execution.setTransitionsToTake(null);
        if (execution.isScope() && activity.isScope()) {
            if (!LegacyBehavior.destroySecondNonScope(execution)) {
                if (execution.isConcurrent()) {
                    LegacyBehavior.destroyConcurrentScope(execution);
                } else {
                    propagatingExecution = execution.getParent();
                    LOG.debugDestroyScope(execution, propagatingExecution);
                    execution.destroy();
                    propagatingExecution.setActivity(execution.getActivity());
                    propagatingExecution.setTransition(execution.getTransition());
                    propagatingExecution.setActive(true);
                    execution.remove();
                }
            }
        } else {
            propagatingExecution = execution;
        }
        if (transitionsToTake.isEmpty()) {
            throw new ProcessEngineException(execution.toString() + ": No outgoing transitions from activity " + String.valueOf(activity));
        }
        if (transitionsToTake.size() == 1) {
            propagatingExecution.setTransition(transitionsToTake.get(0));
            propagatingExecution.take();
        } else {
            propagatingExecution.inactivate();
            ArrayList<OutgoingExecution> outgoingExecutions = new ArrayList<OutgoingExecution>();
            for (int i = 0; i < transitionsToTake.size(); ++i) {
                PvmTransition transition = transitionsToTake.get(i);
                PvmExecutionImpl scopeExecution = propagatingExecution.isScope() ? propagatingExecution : propagatingExecution.getParent();
                PvmExecutionImpl concurrentExecution = null;
                if (i == 0) {
                    concurrentExecution = propagatingExecution;
                } else {
                    concurrentExecution = scopeExecution.createConcurrentExecution();
                    if (i == 1 && !propagatingExecution.isConcurrent()) {
                        outgoingExecutions.remove(0);
                        PvmExecutionImpl replacingExecution = null;
                        for (PvmExecutionImpl pvmExecutionImpl : scopeExecution.getNonEventScopeExecutions()) {
                            if (pvmExecutionImpl == propagatingExecution) continue;
                            replacingExecution = pvmExecutionImpl;
                            break;
                        }
                        outgoingExecutions.add(new OutgoingExecution(replacingExecution, transitionsToTake.get(0)));
                    }
                }
                outgoingExecutions.add(new OutgoingExecution(concurrentExecution, transition));
            }
            Collections.reverse(outgoingExecutions);
            for (OutgoingExecution outgoingExecution : outgoingExecutions) {
                outgoingExecution.take();
            }
        }
    }

    @Override
    public String getCanonicalName() {
        return "transition-destroy-scope";
    }
}

