/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.scripting.engine;

import com.oracle.truffle.js.scriptengine.GraalJSScriptEngine;
import groovy.lang.GroovyClassLoader;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.cibseven.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.codehaus.groovy.jsr223.GroovyScriptEngineImpl;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.HostAccess;

public class CamundaScriptEngineManager
extends ScriptEngineManager {
    private static final String JS_SYNTAX_EXTENSIONS_OPTION = "js.syntax-extensions";
    private static final String JS_SCRIPT_ENGINE_GLOBAL_SCOPE_IMPORT_OPTION = "js.script-engine-global-scope-import";
    private static final String JS_LOAD_OPTION = "js.load";
    private static final String JS_PRINT_OPTION = "js.print";
    private static final String JS_GLOBAL_ARGUMENTS_OPTION = "js.global-arguments";
    public static final String CIBSEVEN_NAMESPACE = "org.cibseven";
    public static final String CAMUNDA_NAMESPACE = "org.camunda";
    protected final Map<String, Runnable> engineNameToInitLogicMappings = Map.of("Graal.js", this::disableGraalVMInterpreterOnlyModeWarnings);

    public CamundaScriptEngineManager() {
        this.applyConfigOnEnginesAfterClasspathDiscovery();
    }

    protected void applyConfigOnEnginesAfterClasspathDiscovery() {
        List<String> engineNames = this.getEngineNamesFoundInClasspath();
        for (String engineName : engineNames) {
            this.executeConfigurationBeforeEngineCreation(engineName);
        }
    }

    protected List<String> getEngineNamesFoundInClasspath() {
        List<ScriptEngineFactory> engineFactories = this.getEngineFactories();
        return engineFactories.stream().map(ScriptEngineFactory::getEngineName).collect(Collectors.toList());
    }

    @Override
    public ScriptEngine getEngineByName(String shortName) {
        boolean useCibSevenNameSpace;
        ProcessEngineConfigurationImpl config = org.cibseven.bpm.engine.impl.context.Context.getProcessEngineConfiguration();
        boolean bl = useCibSevenNameSpace = config != null && config.isUseCibSevenNamespaceInScripting();
        if (useCibSevenNameSpace && "Graal.js".equalsIgnoreCase(shortName)) {
            CibSevenClassLoader cibSevenClassLoader = new CibSevenClassLoader(Thread.currentThread().getContextClassLoader());
            Context.Builder builder = Context.newBuilder("js").allowExperimentalOptions(true).hostClassLoader(cibSevenClassLoader).option(JS_SYNTAX_EXTENSIONS_OPTION, "true").option(JS_LOAD_OPTION, "true").option(JS_PRINT_OPTION, "true").option(JS_GLOBAL_ARGUMENTS_OPTION, "true").option(JS_SCRIPT_ENGINE_GLOBAL_SCOPE_IMPORT_OPTION, "true");
            if (config.isConfigureScriptEngineHostAccess()) {
                builder.allowHostAccess(HostAccess.ALL).allowHostClassLookup(className -> true);
            }
            if (config.isEnableScriptEngineLoadExternalResources()) {
                builder.allowIO(true);
            }
            if (config.isEnableScriptEngineNashornCompatibility()) {
                builder.allowAllAccess(true);
            }
            return GraalJSScriptEngine.create(null, builder);
        }
        if (useCibSevenNameSpace && "groovy".equalsIgnoreCase(shortName)) {
            CibSevenClassLoader cibSevenClassLoader = new CibSevenClassLoader(Thread.currentThread().getContextClassLoader());
            GroovyClassLoader groovyClassLoader = new GroovyClassLoader(cibSevenClassLoader);
            return new GroovyScriptEngineImpl(groovyClassLoader);
        }
        return super.getEngineByName(shortName);
    }

    protected void executeConfigurationBeforeEngineCreation(String engineName) {
        Runnable config = this.engineNameToInitLogicMappings.get(engineName);
        if (config != null) {
            config.run();
        }
    }

    protected void disableGraalVMInterpreterOnlyModeWarnings() {
        System.setProperty("polyglot.engine.WarnInterpreterOnly", "false");
    }

    private static class CibSevenClassLoader
    extends ClassLoader {
        public CibSevenClassLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            if (name != null && name.startsWith(CamundaScriptEngineManager.CAMUNDA_NAMESPACE)) {
                name = name.replace(CamundaScriptEngineManager.CAMUNDA_NAMESPACE, CamundaScriptEngineManager.CIBSEVEN_NAMESPACE);
            }
            return Class.forName(name);
        }
    }
}

