/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.task.listener;

import java.util.List;
import org.cibseven.bpm.engine.ProcessEngineException;
import org.cibseven.bpm.engine.delegate.BaseDelegateExecution;
import org.cibseven.bpm.engine.delegate.DelegateTask;
import org.cibseven.bpm.engine.delegate.Expression;
import org.cibseven.bpm.engine.delegate.TaskListener;
import org.cibseven.bpm.engine.impl.bpmn.parser.FieldDeclaration;
import org.cibseven.bpm.engine.impl.context.Context;
import org.cibseven.bpm.engine.impl.task.delegate.TaskListenerInvocation;
import org.cibseven.bpm.engine.impl.util.ClassDelegateUtil;

public class DelegateExpressionTaskListener
implements TaskListener {
    protected Expression expression;
    private final List<FieldDeclaration> fieldDeclarations;

    public DelegateExpressionTaskListener(Expression expression, List<FieldDeclaration> fieldDeclarations) {
        this.expression = expression;
        this.fieldDeclarations = fieldDeclarations;
    }

    @Override
    public void notify(DelegateTask delegateTask) {
        BaseDelegateExecution variableScope = delegateTask.getExecution();
        if (variableScope == null) {
            variableScope = delegateTask.getCaseExecution();
        }
        Object delegate = this.expression.getValue(variableScope);
        ClassDelegateUtil.applyFieldDeclaration(this.fieldDeclarations, delegate);
        if (delegate instanceof TaskListener) {
            try {
                Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new TaskListenerInvocation((TaskListener)delegate, delegateTask));
            }
            catch (Exception e) {
                throw new ProcessEngineException("Exception while invoking TaskListener: " + e.getMessage(), e);
            }
        } else {
            throw new ProcessEngineException("Delegate expression " + String.valueOf(this.expression) + " did not resolve to an implementation of " + String.valueOf(TaskListener.class));
        }
    }

    public String getExpressionText() {
        return this.expression.getExpressionText();
    }

    public List<FieldDeclaration> getFieldDeclarations() {
        return this.fieldDeclarations;
    }
}

