/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.client.spring.impl.client;

import java.util.ArrayList;
import java.util.List;
import org.cibseven.bpm.client.ExternalTaskClient;
import org.cibseven.bpm.client.ExternalTaskClientBuilder;
import org.cibseven.bpm.client.backoff.BackoffStrategy;
import org.cibseven.bpm.client.interceptor.ClientRequestInterceptor;
import org.cibseven.bpm.client.spring.exception.SpringExternalTaskClientException;
import org.cibseven.bpm.client.spring.impl.client.ClientConfiguration;
import org.cibseven.bpm.client.spring.impl.client.util.ClientLoggerUtil;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.PropertySourcesPropertyResolver;

public class ClientFactory
implements FactoryBean<ExternalTaskClient>,
InitializingBean {
    protected static final ClientLoggerUtil LOG = ClientLoggerUtil.CLIENT_LOGGER;
    protected ClientConfiguration clientConfiguration;
    protected BackoffStrategy backoffStrategy;
    protected List<ClientRequestInterceptor> requestInterceptors = new ArrayList<ClientRequestInterceptor>();
    protected ExternalTaskClient client;
    protected PropertyResolver propertyResolver;

    public ExternalTaskClient getObject() {
        if (this.client == null) {
            ExternalTaskClientBuilder clientBuilder = ExternalTaskClient.create();
            if (this.clientConfiguration.getBaseUrl() != null) {
                clientBuilder.baseUrl(this.resolve(this.clientConfiguration.getBaseUrl()));
            }
            if (this.clientConfiguration.getWorkerId() != null) {
                clientBuilder.workerId(this.resolve(this.clientConfiguration.getWorkerId()));
            }
            this.addClientRequestInterceptors(clientBuilder);
            if (this.clientConfiguration.getMaxTasks() != null) {
                clientBuilder.maxTasks(this.clientConfiguration.getMaxTasks().intValue());
            }
            if (this.clientConfiguration.getUsePriority() != null && !this.clientConfiguration.getUsePriority().booleanValue()) {
                clientBuilder.usePriority(false);
            }
            if (this.clientConfiguration.getDefaultSerializationFormat() != null) {
                clientBuilder.defaultSerializationFormat(this.resolve(this.clientConfiguration.getDefaultSerializationFormat()));
            }
            if (this.clientConfiguration.getDateFormat() != null) {
                clientBuilder.dateFormat(this.resolve(this.clientConfiguration.getDateFormat()));
            }
            if (this.clientConfiguration.getAsyncResponseTimeout() != null) {
                clientBuilder.asyncResponseTimeout(this.clientConfiguration.getAsyncResponseTimeout().longValue());
            }
            if (this.clientConfiguration.getLockDuration() != null) {
                clientBuilder.lockDuration(this.clientConfiguration.getLockDuration().longValue());
            }
            if (this.clientConfiguration.getDisableAutoFetching() != null && this.clientConfiguration.getDisableAutoFetching().booleanValue()) {
                clientBuilder.disableAutoFetching();
            }
            if (this.clientConfiguration.getDisableBackoffStrategy() != null && this.clientConfiguration.getDisableBackoffStrategy().booleanValue()) {
                clientBuilder.disableBackoffStrategy();
            }
            if (this.backoffStrategy != null) {
                clientBuilder.backoffStrategy(this.backoffStrategy);
            }
            this.tryConfigureCreateTimeOrder(clientBuilder);
            this.client = clientBuilder.build();
        }
        LOG.bootstrapped();
        return this.client;
    }

    protected void addClientRequestInterceptors(ExternalTaskClientBuilder taskClientBuilder) {
        this.requestInterceptors.forEach(arg_0 -> ((ExternalTaskClientBuilder)taskClientBuilder).addInterceptor(arg_0));
    }

    protected void tryConfigureCreateTimeOrder(ExternalTaskClientBuilder builder) {
        this.checkForCreateTimeMisconfiguration();
        if (this.isUseCreateTimeEnabled()) {
            builder.orderByCreateTime().desc();
            return;
        }
        if (this.isOrderByCreateTimeEnabled()) {
            this.handleOrderByCreateTimeConfig(builder);
        }
    }

    protected void handleOrderByCreateTimeConfig(ExternalTaskClientBuilder builder) {
        String orderByCreateTime = this.clientConfiguration.getOrderByCreateTime();
        if ("asc".equals(orderByCreateTime)) {
            builder.orderByCreateTime().asc();
            return;
        }
        if ("desc".equals(orderByCreateTime)) {
            builder.orderByCreateTime().desc();
            return;
        }
        throw new SpringExternalTaskClientException("Invalid value " + this.clientConfiguration.getOrderByCreateTime() + ". Please use either \"asc\" or \"desc\" value for configuring \"orderByCreateTime\" on the client");
    }

    protected boolean isOrderByCreateTimeEnabled() {
        return this.clientConfiguration.getOrderByCreateTime() != null;
    }

    protected boolean isUseCreateTimeEnabled() {
        return Boolean.TRUE.equals(this.clientConfiguration.getUseCreateTime());
    }

    protected void checkForCreateTimeMisconfiguration() {
        if (this.isUseCreateTimeEnabled() && this.isOrderByCreateTimeEnabled()) {
            throw new SpringExternalTaskClientException("Both \"useCreateTime\" and \"orderByCreateTime\" are enabled. Please use one or the other");
        }
    }

    @Autowired(required=false)
    public void setRequestInterceptors(List<ClientRequestInterceptor> requestInterceptors) {
        if (requestInterceptors != null) {
            this.requestInterceptors.addAll(requestInterceptors);
            LOG.requestInterceptorsFound(this.requestInterceptors.size());
        }
    }

    @Autowired(required=false)
    public void setClientBackoffStrategy(BackoffStrategy backoffStrategy) {
        this.backoffStrategy = backoffStrategy;
        LOG.backoffStrategyFound();
    }

    public Class<ExternalTaskClient> getObjectType() {
        return ExternalTaskClient.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
    }

    public ClientConfiguration getClientConfiguration() {
        return this.clientConfiguration;
    }

    public void setClientConfiguration(ClientConfiguration clientConfiguration) {
        this.clientConfiguration = clientConfiguration;
    }

    public List<ClientRequestInterceptor> getRequestInterceptors() {
        return this.requestInterceptors;
    }

    protected void close() {
        if (this.client != null) {
            this.client.stop();
        }
    }

    @Autowired(required=false)
    protected void setPropertyConfigurer(PropertySourcesPlaceholderConfigurer configurer) {
        PropertySources appliedPropertySources = configurer.getAppliedPropertySources();
        this.propertyResolver = new PropertySourcesPropertyResolver(appliedPropertySources);
    }

    protected String resolve(String property) {
        if (this.propertyResolver == null) {
            return property;
        }
        if (property != null) {
            return this.propertyResolver.resolvePlaceholders(property);
        }
        return null;
    }
}

