/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.client.impl;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.classic.AbstractHttpClientResponseHandler;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.StatusLine;
import org.cibseven.bpm.client.exception.RestException;
import org.cibseven.bpm.client.impl.EngineClientLogger;
import org.cibseven.bpm.client.impl.EngineRestExceptionDto;
import org.cibseven.bpm.client.impl.ExternalTaskClientLogger;
import org.cibseven.bpm.client.impl.RequestDto;
import org.cibseven.commons.utils.IoUtil;

public class RequestExecutor {
    protected static final EngineClientLogger LOG = ExternalTaskClientLogger.ENGINE_CLIENT_LOGGER;
    protected static final Header HEADER_CONTENT_TYPE_JSON = new BasicHeader("Content-Type", (Object)"application/json");
    protected static final Header HEADER_USER_AGENT = new BasicHeader("User-Agent", (Object)"Camunda External Task Client");
    protected HttpClient httpClient;
    protected ObjectMapper objectMapper;

    protected RequestExecutor(HttpClient httpClient, ObjectMapper objectMapper) {
        this.httpClient = httpClient;
        this.objectMapper = objectMapper;
    }

    protected <T> T postRequest(String resourceUrl, RequestDto requestDto, Class<T> responseClass) {
        ByteArrayEntity serializedRequest = this.serializeRequest(requestDto);
        ClassicHttpRequest httpRequest = ClassicRequestBuilder.post((URI)URI.create(resourceUrl).normalize()).addHeader(HEADER_USER_AGENT).addHeader(HEADER_CONTENT_TYPE_JSON).setEntity((HttpEntity)serializedRequest).build();
        return this.executeRequest(httpRequest, responseClass);
    }

    protected byte[] getRequest(String resourceUrl) {
        ClassicHttpRequest httpRequest = ClassicRequestBuilder.get((URI)URI.create(resourceUrl).normalize()).addHeader(HEADER_USER_AGENT).addHeader(HEADER_CONTENT_TYPE_JSON).build();
        return this.executeRequest(httpRequest, byte[].class);
    }

    protected <T> T executeRequest(ClassicHttpRequest httpRequest, Class<T> responseClass) {
        try {
            return (T)this.httpClient.execute(httpRequest, this.handleResponse(responseClass));
        }
        catch (RestException e) {
            throw LOG.exceptionWhileReceivingResponse((HttpRequest)httpRequest, e);
        }
        catch (IOException e) {
            throw LOG.exceptionWhileEstablishingConnection((HttpRequest)httpRequest, e);
        }
    }

    protected <T> HttpClientResponseHandler<T> handleResponse(final Class<T> responseClass) {
        return new AbstractHttpClientResponseHandler<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public T handleEntity(HttpEntity responseEntity) throws IOException {
                Object response = null;
                if (responseClass.isAssignableFrom(byte[].class)) {
                    InputStream inputStream = null;
                    try {
                        inputStream = responseEntity.getContent();
                        response = IoUtil.inputStreamAsByteArray((InputStream)inputStream);
                    }
                    finally {
                        IoUtil.closeSilently((Closeable)inputStream);
                    }
                } else if (!responseClass.isAssignableFrom(Void.class)) {
                    response = RequestExecutor.this.deserializeResponse(responseEntity, responseClass);
                }
                try {
                    EntityUtils.consume((HttpEntity)responseEntity);
                }
                catch (IOException e) {
                    LOG.exceptionWhileClosingResourceStream(response, e);
                }
                return response;
            }

            public T handleResponse(ClassicHttpResponse response) throws IOException {
                StatusLine statusLine = new StatusLine((HttpResponse)response);
                HttpEntity entity = response.getEntity();
                if (statusLine.getStatusCode() >= 300) {
                    try {
                        RestException engineException = RequestExecutor.this.deserializeResponse(entity, EngineRestExceptionDto.class).toRestException();
                        int statusCode = statusLine.getStatusCode();
                        engineException.setHttpStatusCode(statusCode);
                        throw engineException;
                    }
                    catch (Throwable throwable) {
                        EntityUtils.consume((HttpEntity)entity);
                        throw throwable;
                    }
                }
                return entity == null ? null : (Object)this.handleEntity(entity);
            }
        };
    }

    protected <T> T deserializeResponse(HttpEntity httpEntity, Class<T> responseClass) {
        InputStream inputStream = null;
        try {
            inputStream = httpEntity.getContent();
            Object object = this.objectMapper.readValue(inputStream, responseClass);
            return (T)object;
        }
        catch (JsonParseException e) {
            throw LOG.exceptionWhileParsingJsonObject(responseClass, e);
        }
        catch (JsonMappingException e) {
            throw LOG.exceptionWhileMappingJsonObject(responseClass, e);
        }
        catch (IOException e) {
            throw LOG.exceptionWhileDeserializingJsonObject(responseClass, e);
        }
        finally {
            IoUtil.closeSilently((Closeable)inputStream);
        }
    }

    protected ByteArrayEntity serializeRequest(RequestDto dto) {
        byte[] serializedRequest;
        try {
            serializedRequest = this.objectMapper.writeValueAsBytes((Object)dto);
        }
        catch (JsonProcessingException e) {
            throw LOG.exceptionWhileSerializingJsonObject(dto, e);
        }
        ByteArrayEntity byteArrayEntity = null;
        if (serializedRequest != null) {
            byteArrayEntity = new ByteArrayEntity(serializedRequest, ContentType.APPLICATION_JSON);
        }
        return byteArrayEntity;
    }
}

