/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.client.variable.impl.format.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.cibseven.bpm.client.impl.ExternalTaskClientLogger;
import org.cibseven.bpm.client.spi.DataFormat;
import org.cibseven.bpm.client.variable.impl.format.TypeDetector;
import org.cibseven.bpm.client.variable.impl.format.json.DefaultJsonJacksonTypeDetector;
import org.cibseven.bpm.client.variable.impl.format.json.JacksonJsonLogger;
import org.cibseven.bpm.client.variable.impl.format.json.ListJacksonJsonTypeDetector;
import org.cibseven.commons.utils.EnsureUtil;

public class JacksonJsonDataFormat
implements DataFormat {
    private static final JacksonJsonLogger LOG = ExternalTaskClientLogger.JSON_FORMAT_LOGGER;
    protected String name;
    protected ObjectMapper objectMapper;
    protected List<TypeDetector> typeDetectors;

    public JacksonJsonDataFormat(String name) {
        this(name, new ObjectMapper());
    }

    public JacksonJsonDataFormat(String name, ObjectMapper objectMapper) {
        this.name = name;
        this.objectMapper = objectMapper;
        this.typeDetectors = new ArrayList<TypeDetector>();
        this.typeDetectors.add(new ListJacksonJsonTypeDetector());
        this.typeDetectors.add(new DefaultJsonJacksonTypeDetector());
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public boolean canMap(Object parameter) {
        return parameter != null;
    }

    @Override
    public String writeValue(Object value) {
        try {
            StringWriter stringWriter = new StringWriter();
            this.objectMapper.writeValue((Writer)stringWriter, value);
            return stringWriter.toString();
        }
        catch (IOException e) {
            throw LOG.unableToWriteValue(value, e);
        }
    }

    @Override
    public <T> T readValue(String value, String typeIdentifier) {
        try {
            Class<?> cls = Class.forName(typeIdentifier);
            return (T)this.readValue(value, cls);
        }
        catch (ClassNotFoundException e) {
            JavaType javaType = this.constructJavaTypeFromCanonicalString(typeIdentifier);
            return (T)this.readValue(value, javaType);
        }
    }

    @Override
    public <T> T readValue(String value, Class<T> cls) {
        try {
            return (T)this.objectMapper.readValue(value, cls);
        }
        catch (JsonParseException e) {
            throw LOG.unableToReadValue(value, (Exception)((Object)e));
        }
        catch (JsonMappingException e) {
            throw LOG.unableToReadValue(value, (Exception)((Object)e));
        }
        catch (IOException e) {
            throw LOG.unableToReadValue(value, e);
        }
    }

    protected <C> C readValue(String value, JavaType type) {
        try {
            return (C)this.objectMapper.readValue(value, type);
        }
        catch (JsonParseException e) {
            throw LOG.unableToReadValue(value, (Exception)((Object)e));
        }
        catch (JsonMappingException e) {
            throw LOG.unableToReadValue(value, (Exception)((Object)e));
        }
        catch (IOException e) {
            throw LOG.unableToReadValue(value, e);
        }
    }

    public JavaType constructJavaTypeFromCanonicalString(String canonicalString) {
        try {
            return TypeFactory.defaultInstance().constructFromCanonical(canonicalString);
        }
        catch (IllegalArgumentException e) {
            throw LOG.unableToConstructJavaType(canonicalString, e);
        }
    }

    @Override
    public String getCanonicalTypeName(Object value) {
        EnsureUtil.ensureNotNull((String)"value", (Object)value);
        for (TypeDetector typeDetector : this.typeDetectors) {
            if (!typeDetector.canHandle(value)) continue;
            return typeDetector.detectType(value);
        }
        throw LOG.unableToDetectCanonicalType(value);
    }
}

