/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.client.variable.impl.value;

import java.io.InputStream;
import org.cibseven.bpm.client.impl.EngineClient;
import org.cibseven.bpm.client.impl.EngineClientException;
import org.cibseven.bpm.client.impl.ExternalTaskClientLogger;
import org.cibseven.bpm.client.variable.value.DeferredFileValue;
import org.cibseven.bpm.engine.variable.impl.value.FileValueImpl;
import org.cibseven.bpm.engine.variable.type.PrimitiveValueType;

public class DeferredFileValueImpl
extends FileValueImpl
implements DeferredFileValue {
    private static final long serialVersionUID = 1L;
    protected static final ExternalTaskClientLogger LOG = ExternalTaskClientLogger.CLIENT_LOGGER;
    protected boolean isLoaded = false;
    protected String variableName;
    protected String executionId;
    protected EngineClient engineClient;

    public DeferredFileValueImpl(String filename, EngineClient engineClient) {
        super(PrimitiveValueType.FILE, filename);
        this.engineClient = engineClient;
    }

    protected void load() {
        try {
            byte[] bytes = this.engineClient.getLocalBinaryVariable(this.variableName, this.executionId);
            this.setValue(bytes);
            this.isLoaded = true;
        }
        catch (EngineClientException e) {
            throw LOG.handledEngineClientException("loading deferred file", e);
        }
    }

    @Override
    public boolean isLoaded() {
        return this.isLoaded;
    }

    public InputStream getValue() {
        if (!this.isLoaded()) {
            this.load();
        }
        return super.getValue();
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String toString() {
        return "DeferredFileValueImpl [mimeType=" + this.mimeType + ", filename=" + this.filename + ", type=" + this.type + ", isTransient=" + this.isTransient + ", isLoaded=" + this.isLoaded + "]";
    }
}

