/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.client.impl;

import java.io.IOException;
import org.apache.hc.core5.http.HttpRequest;
import org.cibseven.bpm.client.exception.RestException;
import org.cibseven.bpm.client.impl.EngineClientException;
import org.cibseven.bpm.client.impl.ExternalTaskClientLogger;
import org.cibseven.bpm.client.impl.RequestDto;

public class EngineClientLogger
extends ExternalTaskClientLogger {
    protected EngineClientException exceptionWhileReceivingResponse(HttpRequest httpRequest, RestException e) {
        return new EngineClientException(this.exceptionMessage("001", "Request '{}' returned error: status code '{}' - message: {}", new Object[]{httpRequest, e.getHttpStatusCode(), e.getMessage()}), e);
    }

    protected EngineClientException exceptionWhileEstablishingConnection(HttpRequest httpRequest, IOException e) {
        return new EngineClientException(this.exceptionMessage("002", "Exception while establishing connection for request '{}'", new Object[]{httpRequest}), e);
    }

    protected <T> void exceptionWhileClosingResourceStream(T response, IOException e) {
        this.logError("003", "Exception while closing resource stream of response '" + String.valueOf(response) + "': ", e);
    }

    protected <T> EngineClientException exceptionWhileParsingJsonObject(Class<T> responseDtoClass, Throwable t) {
        return new EngineClientException(this.exceptionMessage("004", "Exception while parsing json object to response dto class '{}'", new Object[]{responseDtoClass}), t);
    }

    protected <T> EngineClientException exceptionWhileMappingJsonObject(Class<T> responseDtoClass, Throwable t) {
        return new EngineClientException(this.exceptionMessage("005", "Exception while mapping json object to response dto class '{}'", new Object[]{responseDtoClass}), t);
    }

    protected <T> EngineClientException exceptionWhileDeserializingJsonObject(Class<T> responseDtoClass, Throwable t) {
        return new EngineClientException(this.exceptionMessage("006", "Exception while deserializing json object to response dto class '{}'", new Object[]{responseDtoClass}), t);
    }

    protected <D extends RequestDto> EngineClientException exceptionWhileSerializingJsonObject(D dto, Throwable t) {
        return new EngineClientException(this.exceptionMessage("007", "Exception while serializing json object to '{}'", new Object[]{dto}), t);
    }

    public void requestInterceptorException(Throwable e) {
        this.logError("008", "Exception while executing request interceptor: {}", e);
    }
}

