/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.client.interceptor.auth;

import java.nio.charset.Charset;
import java.util.Base64;
import org.cibseven.bpm.client.impl.ExternalTaskClientLogger;
import org.cibseven.bpm.client.interceptor.ClientRequestContext;
import org.cibseven.bpm.client.interceptor.ClientRequestInterceptor;

public class BasicAuthProvider
implements ClientRequestInterceptor {
    protected static final ExternalTaskClientLogger LOG = ExternalTaskClientLogger.CLIENT_LOGGER;
    protected String username;
    protected String password;

    public BasicAuthProvider(String username, String password) {
        if (username == null || password == null) {
            throw LOG.basicAuthCredentialsNullException();
        }
        this.username = username;
        this.password = password;
    }

    @Override
    public void intercept(ClientRequestContext requestContext) {
        String authToken = this.username + ":" + this.password;
        String encodedAuthToken = this.encodeToBase64(authToken);
        requestContext.addHeader("Authorization", "Basic " + encodedAuthToken);
    }

    protected String encodeToBase64(String decodedString) {
        byte[] stringAsBytes = decodedString.getBytes(Charset.defaultCharset());
        return Base64.getEncoder().encodeToString(stringAsBytes);
    }
}

