/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.impl.juel;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.cibseven.bpm.impl.juel.Tree;
import org.cibseven.bpm.impl.juel.TreeCache;

public final class Cache
implements TreeCache {
    private final Map<String, Tree> primary;
    private final Map<String, Tree> secondary;

    public Cache(int size) {
        this(size, new WeakHashMap<String, Tree>());
    }

    public Cache(final int size, Map<String, Tree> secondary) {
        this.primary = Collections.synchronizedMap(new LinkedHashMap<String, Tree>(16, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Tree> eldest) {
                if (this.size() > size) {
                    if (Cache.this.secondary != null) {
                        Cache.this.secondary.put(eldest.getKey(), eldest.getValue());
                    }
                    return true;
                }
                return false;
            }
        });
        this.secondary = secondary == null ? null : Collections.synchronizedMap(secondary);
    }

    @Override
    public Tree get(String expression) {
        if (this.secondary == null) {
            return this.primary.get(expression);
        }
        Tree tree = this.primary.get(expression);
        if (tree == null) {
            tree = this.secondary.get(expression);
        }
        return tree;
    }

    @Override
    public void put(String expression, Tree tree) {
        this.primary.put(expression, tree);
    }
}

