/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.impl.juel;

import org.cibseven.bpm.impl.juel.LocalMessages;
import org.cibseven.bpm.impl.juel.TypeConverter;
import org.cibseven.bpm.impl.juel.jakarta.el.ELContext;
import org.cibseven.bpm.impl.juel.jakarta.el.ELException;
import org.cibseven.bpm.impl.juel.jakarta.el.ValueExpression;

public final class ObjectValueExpression
extends ValueExpression {
    private static final long serialVersionUID = 1L;
    private final TypeConverter converter;
    private final Object object;
    private final Class<?> type;

    public ObjectValueExpression(TypeConverter converter, Object object, Class<?> type) {
        this.converter = converter;
        this.object = object;
        this.type = type;
        if (type == null) {
            throw new NullPointerException(LocalMessages.get("error.value.notype", new Object[0]));
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == this.getClass()) {
            ObjectValueExpression other = (ObjectValueExpression)obj;
            if (this.type != other.type) {
                return false;
            }
            return this.object == other.object || this.object != null && this.object.equals(other.object);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.object == null ? 0 : this.object.hashCode();
    }

    @Override
    public Object getValue(ELContext context) {
        return this.converter.convert(this.object, this.type);
    }

    @Override
    public String getExpressionString() {
        return null;
    }

    @Override
    public boolean isLiteralText() {
        return false;
    }

    @Override
    public Class<?> getType(ELContext context) {
        return null;
    }

    @Override
    public boolean isReadOnly(ELContext context) {
        return true;
    }

    @Override
    public void setValue(ELContext context, Object value) {
        throw new ELException(LocalMessages.get("error.value.set.rvalue", "<object value expression>"));
    }

    public String toString() {
        return "ValueExpression(" + this.object + ")";
    }

    @Override
    public Class<?> getExpectedType() {
        return this.type;
    }
}

