/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.impl.juel;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.cibseven.bpm.impl.juel.SimpleResolver;
import org.cibseven.bpm.impl.juel.jakarta.el.ELContext;
import org.cibseven.bpm.impl.juel.jakarta.el.ELResolver;
import org.cibseven.bpm.impl.juel.jakarta.el.FunctionMapper;
import org.cibseven.bpm.impl.juel.jakarta.el.ValueExpression;
import org.cibseven.bpm.impl.juel.jakarta.el.VariableMapper;

public class SimpleContext
extends ELContext {
    private Functions functions;
    private Variables variables;
    private ELResolver resolver;

    public SimpleContext() {
        this(null);
    }

    public SimpleContext(ELResolver resolver) {
        this.resolver = resolver;
    }

    public void setFunction(String prefix, String localName, Method method) {
        if (this.functions == null) {
            this.functions = new Functions();
        }
        this.functions.setFunction(prefix, localName, method);
    }

    public ValueExpression setVariable(String name, ValueExpression expression) {
        if (this.variables == null) {
            this.variables = new Variables();
        }
        return this.variables.setVariable(name, expression);
    }

    @Override
    public FunctionMapper getFunctionMapper() {
        if (this.functions == null) {
            this.functions = new Functions();
        }
        return this.functions;
    }

    @Override
    public VariableMapper getVariableMapper() {
        if (this.variables == null) {
            this.variables = new Variables();
        }
        return this.variables;
    }

    @Override
    public ELResolver getELResolver() {
        if (this.resolver == null) {
            this.resolver = new SimpleResolver();
        }
        return this.resolver;
    }

    public void setELResolver(ELResolver resolver) {
        this.resolver = resolver;
    }

    static class Functions
    extends FunctionMapper {
        Map<String, Method> map = Collections.emptyMap();

        Functions() {
        }

        @Override
        public Method resolveFunction(String prefix, String localName) {
            return this.map.get(prefix + ":" + localName);
        }

        public void setFunction(String prefix, String localName, Method method) {
            if (this.map.isEmpty()) {
                this.map = new HashMap<String, Method>();
            }
            this.map.put(prefix + ":" + localName, method);
        }
    }

    static class Variables
    extends VariableMapper {
        Map<String, ValueExpression> map = Collections.emptyMap();

        Variables() {
        }

        @Override
        public ValueExpression resolveVariable(String variable) {
            return this.map.get(variable);
        }

        @Override
        public ValueExpression setVariable(String variable, ValueExpression expression) {
            if (this.map.isEmpty()) {
                this.map = new HashMap<String, ValueExpression>();
            }
            return this.map.put(variable, expression);
        }
    }
}

