/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.impl.juel;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import org.cibseven.bpm.impl.juel.Bindings;
import org.cibseven.bpm.impl.juel.ExpressionNode;
import org.cibseven.bpm.impl.juel.LocalMessages;
import org.cibseven.bpm.impl.juel.NodePrinter;
import org.cibseven.bpm.impl.juel.Tree;
import org.cibseven.bpm.impl.juel.TreeBuilder;
import org.cibseven.bpm.impl.juel.TreeStore;
import org.cibseven.bpm.impl.juel.TypeConverter;
import org.cibseven.bpm.impl.juel.jakarta.el.ELContext;
import org.cibseven.bpm.impl.juel.jakarta.el.ELException;
import org.cibseven.bpm.impl.juel.jakarta.el.FunctionMapper;
import org.cibseven.bpm.impl.juel.jakarta.el.MethodExpression;
import org.cibseven.bpm.impl.juel.jakarta.el.MethodInfo;
import org.cibseven.bpm.impl.juel.jakarta.el.VariableMapper;

public final class TreeMethodExpression
extends MethodExpression {
    private static final long serialVersionUID = 1L;
    private final TreeBuilder builder;
    private final Bindings bindings;
    private final String expr;
    private final Class<?> type;
    private final Class<?>[] types;
    private final boolean deferred;
    private transient ExpressionNode node;
    private String structure;

    public TreeMethodExpression(TreeStore store, FunctionMapper functions, VariableMapper variables, TypeConverter converter, String expr, Class<?> returnType, Class<?>[] paramTypes) {
        Tree tree = store.get(expr);
        this.builder = store.getBuilder();
        this.bindings = tree.bind(functions, variables, converter);
        this.expr = expr;
        this.type = returnType;
        this.types = paramTypes;
        this.node = tree.getRoot();
        this.deferred = tree.isDeferred();
        if (this.node.isLiteralText()) {
            if (returnType == Void.TYPE) {
                throw new ELException(LocalMessages.get("error.method.literal.void", expr));
            }
        } else if (!this.node.isMethodInvocation()) {
            if (!this.node.isLeftValue()) {
                throw new ELException(LocalMessages.get("error.method.invalid", expr));
            }
            if (paramTypes == null) {
                throw new ELException(LocalMessages.get("error.method.notypes", new Object[0]));
            }
        }
    }

    private String getStructuralId() {
        if (this.structure == null) {
            this.structure = this.node.getStructuralId(this.bindings);
        }
        return this.structure;
    }

    @Override
    public MethodInfo getMethodInfo(ELContext context) throws ELException {
        return this.node.getMethodInfo(this.bindings, context, this.type, this.types);
    }

    @Override
    public String getExpressionString() {
        return this.expr;
    }

    @Override
    public Object invoke(ELContext context, Object[] paramValues) throws ELException {
        return this.node.invoke(this.bindings, context, this.type, this.types, paramValues);
    }

    @Override
    public boolean isLiteralText() {
        return this.node.isLiteralText();
    }

    @Override
    public boolean isParametersProvided() {
        return this.node.isMethodInvocation();
    }

    public boolean isDeferred() {
        return this.deferred;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == this.getClass()) {
            TreeMethodExpression other = (TreeMethodExpression)obj;
            if (!this.builder.equals(other.builder)) {
                return false;
            }
            if (this.type != other.type) {
                return false;
            }
            if (!Arrays.equals(this.types, other.types)) {
                return false;
            }
            return this.getStructuralId().equals(other.getStructuralId()) && this.bindings.equals(other.bindings);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getStructuralId().hashCode();
    }

    public String toString() {
        return "TreeMethodExpression(" + this.expr + ")";
    }

    public void dump(PrintWriter writer) {
        NodePrinter.dump(writer, this.node);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.node = this.builder.build(this.expr).getRoot();
        }
        catch (ELException e) {
            throw new IOException(e.getMessage());
        }
    }
}

