/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.impl.juel.jakarta.el;

import java.lang.reflect.Method;
import org.cibseven.bpm.impl.juel.jakarta.el.BeanNameELResolver;
import org.cibseven.bpm.impl.juel.jakarta.el.BeanNameResolver;
import org.cibseven.bpm.impl.juel.jakarta.el.ELContext;
import org.cibseven.bpm.impl.juel.jakarta.el.ELException;
import org.cibseven.bpm.impl.juel.jakarta.el.ELResolver;
import org.cibseven.bpm.impl.juel.jakarta.el.ELUtil;
import org.cibseven.bpm.impl.juel.jakarta.el.EvaluationListener;
import org.cibseven.bpm.impl.juel.jakarta.el.ExpressionFactory;
import org.cibseven.bpm.impl.juel.jakarta.el.StandardELContext;
import org.cibseven.bpm.impl.juel.jakarta.el.ValueExpression;

public class ELManager {
    private StandardELContext elContext;

    public static ExpressionFactory getExpressionFactory() {
        return ELUtil.getExpressionFactory();
    }

    public StandardELContext getELContext() {
        if (this.elContext == null) {
            this.elContext = new StandardELContext(ELManager.getExpressionFactory());
        }
        return this.elContext;
    }

    public ELContext setELContext(ELContext context) {
        StandardELContext prevELContext = this.elContext;
        this.elContext = new StandardELContext(context);
        return prevELContext;
    }

    public void addBeanNameResolver(BeanNameResolver beanNameResolver) {
        this.getELContext().addELResolver(new BeanNameELResolver(beanNameResolver));
    }

    public void addELResolver(ELResolver elResolver) {
        this.getELContext().addELResolver(elResolver);
    }

    public void mapFunction(String prefix, String function, Method method) {
        this.getELContext().getFunctionMapper().mapFunction(prefix, function, method);
    }

    public void setVariable(String variable, ValueExpression expression) {
        this.getELContext().getVariableMapper().setVariable(variable, expression);
    }

    public void importStatic(String staticMemberName) throws ELException {
        this.getELContext().getImportHandler().importStatic(staticMemberName);
    }

    public void importClass(String className) throws ELException {
        this.getELContext().getImportHandler().importClass(className);
    }

    public void importPackage(String packageName) {
        this.getELContext().getImportHandler().importPackage(packageName);
    }

    public Object defineBean(String name, Object bean) {
        Object previousBean = this.getELContext().getBeans().get(name);
        this.getELContext().getBeans().put(name, bean);
        return previousBean;
    }

    public void addEvaluationListener(EvaluationListener listener) {
        this.getELContext().addEvaluationListener(listener);
    }
}

