/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.model.bpmn.builder;

import java.util.ArrayList;
import java.util.Collection;
import org.cibseven.bpm.model.bpmn.BpmnModelInstance;
import org.cibseven.bpm.model.bpmn.builder.AbstractFlowNodeBuilder;
import org.cibseven.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.cibseven.bpm.model.bpmn.builder.MultiInstanceLoopCharacteristicsBuilder;
import org.cibseven.bpm.model.bpmn.instance.Activity;
import org.cibseven.bpm.model.bpmn.instance.BaseElement;
import org.cibseven.bpm.model.bpmn.instance.BoundaryEvent;
import org.cibseven.bpm.model.bpmn.instance.MultiInstanceLoopCharacteristics;
import org.cibseven.bpm.model.bpmn.instance.bpmndi.BpmnShape;
import org.cibseven.bpm.model.bpmn.instance.camunda.CamundaInputOutput;
import org.cibseven.bpm.model.bpmn.instance.camunda.CamundaInputParameter;
import org.cibseven.bpm.model.bpmn.instance.camunda.CamundaOutputParameter;
import org.cibseven.bpm.model.bpmn.instance.dc.Bounds;

public abstract class AbstractActivityBuilder<B extends AbstractActivityBuilder<B, E>, E extends Activity>
extends AbstractFlowNodeBuilder<B, E> {
    protected AbstractActivityBuilder(BpmnModelInstance modelInstance, E element, Class<?> selfType) {
        super(modelInstance, element, selfType);
    }

    public BoundaryEventBuilder boundaryEvent() {
        return this.boundaryEvent(null);
    }

    public BoundaryEventBuilder boundaryEvent(String id) {
        BoundaryEvent boundaryEvent = this.createSibling(BoundaryEvent.class, id);
        boundaryEvent.setAttachedTo((Activity)this.element);
        BpmnShape boundaryEventBpmnShape = this.createBpmnShape(boundaryEvent);
        this.setBoundaryEventCoordinates(boundaryEventBpmnShape);
        return boundaryEvent.builder();
    }

    public MultiInstanceLoopCharacteristicsBuilder multiInstance() {
        MultiInstanceLoopCharacteristics miCharacteristics = this.createChild(MultiInstanceLoopCharacteristics.class);
        return miCharacteristics.builder();
    }

    public B camundaInputParameter(String name, String value) {
        CamundaInputOutput camundaInputOutput = this.getCreateSingleExtensionElement(CamundaInputOutput.class);
        CamundaInputParameter camundaInputParameter = this.createChild(camundaInputOutput, CamundaInputParameter.class);
        camundaInputParameter.setCamundaName(name);
        camundaInputParameter.setTextContent(value);
        return (B)((AbstractActivityBuilder)this.myself);
    }

    public B camundaOutputParameter(String name, String value) {
        CamundaInputOutput camundaInputOutput = this.getCreateSingleExtensionElement(CamundaInputOutput.class);
        CamundaOutputParameter camundaOutputParameter = this.createChild(camundaInputOutput, CamundaOutputParameter.class);
        camundaOutputParameter.setCamundaName(name);
        camundaOutputParameter.setTextContent(value);
        return (B)((AbstractActivityBuilder)this.myself);
    }

    protected double calculateXCoordinate(Bounds boundaryEventBounds) {
        BpmnShape attachedToElement = this.findBpmnShape((BaseElement)this.element);
        double x = 0.0;
        if (attachedToElement != null) {
            Bounds attachedToBounds = attachedToElement.getBounds();
            Collection boundaryEvents = ((Activity)this.element).getParentElement().getChildElementsByType(BoundaryEvent.class);
            ArrayList<BoundaryEvent> attachedBoundaryEvents = new ArrayList<BoundaryEvent>();
            for (BoundaryEvent tmp : boundaryEvents) {
                if (!tmp.getAttachedTo().equals(this.element)) continue;
                attachedBoundaryEvents.add(tmp);
            }
            double attachedToX = attachedToBounds.getX();
            double attachedToWidth = attachedToBounds.getWidth();
            double boundaryWidth = boundaryEventBounds.getWidth();
            switch (attachedBoundaryEvents.size()) {
                case 2: {
                    x = attachedToX + attachedToWidth / 2.0 + boundaryWidth / 2.0;
                    break;
                }
                case 3: {
                    x = attachedToX + attachedToWidth / 2.0 - 1.5 * boundaryWidth;
                    break;
                }
                default: {
                    x = attachedToX + attachedToWidth / 2.0 - boundaryWidth / 2.0;
                }
            }
        }
        return x;
    }

    protected void setBoundaryEventCoordinates(BpmnShape bpmnShape) {
        BpmnShape activity = this.findBpmnShape((BaseElement)this.element);
        Bounds boundaryBounds = bpmnShape.getBounds();
        double x = 0.0;
        double y = 0.0;
        if (activity != null) {
            Bounds activityBounds = activity.getBounds();
            double activityY = activityBounds.getY();
            double activityHeight = activityBounds.getHeight();
            double boundaryHeight = boundaryBounds.getHeight();
            x = this.calculateXCoordinate(boundaryBounds);
            y = activityY + activityHeight - boundaryHeight / 2.0;
        }
        boundaryBounds.setX(x);
        boundaryBounds.setY(y);
    }
}

