/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.model.dmn.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.cibseven.bpm.model.dmn.DmnModelException;
import org.cibseven.bpm.model.dmn.Query;
import org.cibseven.bpm.model.xml.instance.ModelElementInstance;
import org.cibseven.bpm.model.xml.type.ModelElementType;

public class QueryImpl<T extends ModelElementInstance>
implements Query<T> {
    private final Collection<T> collection;

    public QueryImpl(Collection<T> collection) {
        this.collection = collection;
    }

    @Override
    public List<T> list() {
        return new ArrayList<T>(this.collection);
    }

    @Override
    public int count() {
        return this.collection.size();
    }

    @Override
    public <V extends ModelElementInstance> Query<V> filterByType(ModelElementType elementType) {
        Class elementClass = elementType.getInstanceType();
        return this.filterByType(elementClass);
    }

    @Override
    public <V extends ModelElementInstance> Query<V> filterByType(Class<V> elementClass) {
        ArrayList<ModelElementInstance> filtered = new ArrayList<ModelElementInstance>();
        for (ModelElementInstance instance : this.collection) {
            if (!elementClass.isAssignableFrom(instance.getClass())) continue;
            filtered.add(instance);
        }
        return new QueryImpl(filtered);
    }

    @Override
    public T singleResult() {
        if (this.collection.size() == 1) {
            return (T)((ModelElementInstance)this.collection.iterator().next());
        }
        throw new DmnModelException("Collection expected to have <1> entry but has <" + this.collection.size() + ">");
    }
}

