/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.model.xml.impl.type;

import java.util.ArrayList;
import java.util.List;
import org.cibseven.bpm.model.xml.Model;
import org.cibseven.bpm.model.xml.ModelException;
import org.cibseven.bpm.model.xml.impl.ModelBuildOperation;
import org.cibseven.bpm.model.xml.impl.ModelImpl;
import org.cibseven.bpm.model.xml.impl.type.ModelElementTypeImpl;
import org.cibseven.bpm.model.xml.impl.type.attribute.BooleanAttributeBuilder;
import org.cibseven.bpm.model.xml.impl.type.attribute.DoubleAttributeBuilder;
import org.cibseven.bpm.model.xml.impl.type.attribute.EnumAttributeBuilder;
import org.cibseven.bpm.model.xml.impl.type.attribute.IntegerAttributeBuilder;
import org.cibseven.bpm.model.xml.impl.type.attribute.NamedEnumAttributeBuilder;
import org.cibseven.bpm.model.xml.impl.type.attribute.StringAttributeBuilderImpl;
import org.cibseven.bpm.model.xml.impl.type.child.SequenceBuilderImpl;
import org.cibseven.bpm.model.xml.instance.ModelElementInstance;
import org.cibseven.bpm.model.xml.type.ModelElementType;
import org.cibseven.bpm.model.xml.type.ModelElementTypeBuilder;
import org.cibseven.bpm.model.xml.type.attribute.AttributeBuilder;
import org.cibseven.bpm.model.xml.type.attribute.StringAttributeBuilder;
import org.cibseven.bpm.model.xml.type.child.SequenceBuilder;

public class ModelElementTypeBuilderImpl
implements ModelElementTypeBuilder,
ModelBuildOperation {
    private final ModelElementTypeImpl modelType;
    private final ModelImpl model;
    private final Class<? extends ModelElementInstance> instanceType;
    private final List<ModelBuildOperation> modelBuildOperations = new ArrayList<ModelBuildOperation>();
    private Class<? extends ModelElementInstance> extendedType;

    public ModelElementTypeBuilderImpl(Class<? extends ModelElementInstance> instanceType, String name, ModelImpl model) {
        this.instanceType = instanceType;
        this.model = model;
        this.modelType = new ModelElementTypeImpl(model, name, instanceType);
    }

    @Override
    public ModelElementTypeBuilder extendsType(Class<? extends ModelElementInstance> extendedType) {
        this.extendedType = extendedType;
        return this;
    }

    @Override
    public <T extends ModelElementInstance> ModelElementTypeBuilder instanceProvider(ModelElementTypeBuilder.ModelTypeInstanceProvider<T> instanceProvider) {
        this.modelType.setInstanceProvider(instanceProvider);
        return this;
    }

    @Override
    public ModelElementTypeBuilder namespaceUri(String namespaceUri) {
        this.modelType.setTypeNamespace(namespaceUri);
        return this;
    }

    @Override
    public AttributeBuilder<Boolean> booleanAttribute(String attributeName) {
        BooleanAttributeBuilder builder = new BooleanAttributeBuilder(attributeName, this.modelType);
        this.modelBuildOperations.add(builder);
        return builder;
    }

    @Override
    public StringAttributeBuilder stringAttribute(String attributeName) {
        StringAttributeBuilderImpl builder = new StringAttributeBuilderImpl(attributeName, this.modelType);
        this.modelBuildOperations.add(builder);
        return builder;
    }

    @Override
    public AttributeBuilder<Integer> integerAttribute(String attributeName) {
        IntegerAttributeBuilder builder = new IntegerAttributeBuilder(attributeName, this.modelType);
        this.modelBuildOperations.add(builder);
        return builder;
    }

    @Override
    public AttributeBuilder<Double> doubleAttribute(String attributeName) {
        DoubleAttributeBuilder builder = new DoubleAttributeBuilder(attributeName, this.modelType);
        this.modelBuildOperations.add(builder);
        return builder;
    }

    @Override
    public <V extends Enum<V>> AttributeBuilder<V> enumAttribute(String attributeName, Class<V> enumType) {
        EnumAttributeBuilder<V> builder = new EnumAttributeBuilder<V>(attributeName, this.modelType, enumType);
        this.modelBuildOperations.add(builder);
        return builder;
    }

    @Override
    public <V extends Enum<V>> AttributeBuilder<V> namedEnumAttribute(String attributeName, Class<V> enumType) {
        NamedEnumAttributeBuilder<V> builder = new NamedEnumAttributeBuilder<V>(attributeName, this.modelType, enumType);
        this.modelBuildOperations.add(builder);
        return builder;
    }

    @Override
    public ModelElementType build() {
        this.model.registerType(this.modelType, this.instanceType);
        return this.modelType;
    }

    @Override
    public ModelElementTypeBuilder abstractType() {
        this.modelType.setAbstract(true);
        return this;
    }

    @Override
    public SequenceBuilder sequence() {
        SequenceBuilderImpl builder = new SequenceBuilderImpl(this.modelType);
        this.modelBuildOperations.add(builder);
        return builder;
    }

    public void buildTypeHierarchy(Model model) {
        if (this.extendedType != null) {
            ModelElementTypeImpl extendedModelElementType = (ModelElementTypeImpl)model.getType(this.extendedType);
            if (extendedModelElementType == null) {
                throw new ModelException("Type " + this.modelType + " is defined to extend " + this.extendedType + " but no such type is defined.");
            }
            this.modelType.setBaseType(extendedModelElementType);
            extendedModelElementType.registerExtendingType(this.modelType);
        }
    }

    @Override
    public void performModelBuild(Model model) {
        for (ModelBuildOperation operation : this.modelBuildOperations) {
            operation.performModelBuild(model);
        }
    }
}

