/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.model.xml.impl.type.reference;

import org.cibseven.bpm.model.xml.Model;
import org.cibseven.bpm.model.xml.ModelException;
import org.cibseven.bpm.model.xml.impl.ModelBuildOperation;
import org.cibseven.bpm.model.xml.impl.type.ModelElementTypeImpl;
import org.cibseven.bpm.model.xml.impl.type.attribute.AttributeImpl;
import org.cibseven.bpm.model.xml.instance.ModelElementInstance;
import org.cibseven.bpm.model.xml.type.reference.AttributeReferenceCollection;
import org.cibseven.bpm.model.xml.type.reference.AttributeReferenceCollectionBuilder;

public class AttributeReferenceCollectionBuilderImpl<T extends ModelElementInstance>
implements AttributeReferenceCollectionBuilder<T>,
ModelBuildOperation {
    private final AttributeImpl<String> referenceSourceAttribute;
    protected AttributeReferenceCollection<T> attributeReferenceCollection;
    private final Class<T> referenceTargetElement;

    public AttributeReferenceCollectionBuilderImpl(AttributeImpl<String> attribute, Class<T> referenceTargetElement, Class<? extends AttributeReferenceCollection> attributeReferenceCollection) {
        this.referenceSourceAttribute = attribute;
        this.referenceTargetElement = referenceTargetElement;
        try {
            this.attributeReferenceCollection = attributeReferenceCollection.getConstructor(AttributeImpl.class).newInstance(this.referenceSourceAttribute);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public AttributeReferenceCollection<T> build() {
        this.referenceSourceAttribute.registerOutgoingReference(this.attributeReferenceCollection);
        return this.attributeReferenceCollection;
    }

    @Override
    public void performModelBuild(Model model) {
        ModelElementTypeImpl referenceTargetType = (ModelElementTypeImpl)model.getType(this.referenceTargetElement);
        this.attributeReferenceCollection.setReferenceTargetElementType(referenceTargetType);
        AttributeImpl idAttribute = (AttributeImpl)referenceTargetType.getAttribute("id");
        if (idAttribute == null) {
            throw new ModelException("Element type " + referenceTargetType.getTypeNamespace() + ":" + referenceTargetType.getTypeName() + " has no id attribute");
        }
        idAttribute.registerIncoming(this.attributeReferenceCollection);
        this.attributeReferenceCollection.setReferenceTargetAttribute(idAttribute);
    }
}

