/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.spring.boot.starter;

import jakarta.servlet.ServletContext;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.cibseven.bpm.application.PostDeploy;
import org.cibseven.bpm.application.PreUndeploy;
import org.cibseven.bpm.container.RuntimeContainerDelegate;
import org.cibseven.bpm.engine.ProcessEngine;
import org.cibseven.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.cibseven.bpm.engine.spring.application.SpringProcessApplication;
import org.cibseven.bpm.spring.boot.starter.configuration.CamundaDeploymentConfiguration;
import org.cibseven.bpm.spring.boot.starter.event.PostDeployEvent;
import org.cibseven.bpm.spring.boot.starter.event.PreUndeployEvent;
import org.cibseven.bpm.spring.boot.starter.property.CamundaBpmProperties;
import org.cibseven.bpm.spring.boot.starter.util.GetProcessApplicationNameFromAnnotation;
import org.cibseven.bpm.spring.boot.starter.util.SpringBootProcessEngineLogger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ServletContextAware;

@Configuration
public class SpringBootProcessApplication
extends SpringProcessApplication {
    @Value(value="${spring.application.name:null}")
    protected Optional<String> springApplicationName;
    protected String contextPath = "/";
    @Autowired
    protected CamundaBpmProperties camundaBpmProperties;
    @Autowired
    protected ProcessEngine processEngine;
    @Autowired
    protected ApplicationEventPublisher eventPublisher;

    @Bean
    public static CamundaDeploymentConfiguration deploymentConfiguration() {
        return new CamundaDeploymentConfiguration(){

            @Override
            public Set<Resource> getDeploymentResources() {
                return Collections.emptySet();
            }

            @Override
            public void preInit(ProcessEngineConfigurationImpl configuration) {
                SpringBootProcessEngineLogger.LOG.skipAutoDeployment();
            }

            public String toString() {
                return "disableDeploymentResourcePattern";
            }
        };
    }

    public void afterPropertiesSet() throws Exception {
        GetProcessApplicationNameFromAnnotation.processApplicationNameFromAnnotation(this.applicationContext).apply(this.springApplicationName).ifPresent(arg_0 -> ((SpringBootProcessApplication)this).setBeanName(arg_0));
        if (this.camundaBpmProperties.getGenerateUniqueProcessApplicationName().booleanValue()) {
            this.setBeanName(CamundaBpmProperties.getUniqueName("processApplication"));
        }
        String processEngineName = this.processEngine.getName();
        this.setDefaultDeployToEngineName(processEngineName);
        RuntimeContainerDelegate.INSTANCE.get().registerProcessEngine(this.processEngine);
        this.properties.put("servletContextPath", this.contextPath);
        super.afterPropertiesSet();
    }

    public void destroy() throws Exception {
        super.destroy();
        RuntimeContainerDelegate.INSTANCE.get().unregisterProcessEngine(this.processEngine);
    }

    @PostDeploy
    public void onPostDeploy(ProcessEngine processEngine) {
        this.eventPublisher.publishEvent((Object)new PostDeployEvent(processEngine));
    }

    @PreUndeploy
    public void onPreUndeploy(ProcessEngine processEngine) {
        this.eventPublisher.publishEvent((Object)new PreUndeployEvent(processEngine));
    }

    @ConditionalOnWebApplication
    @Configuration
    class WebApplicationConfiguration
    implements ServletContextAware {
        WebApplicationConfiguration() {
        }

        public void setServletContext(ServletContext servletContext) {
            if (!StringUtils.isEmpty((Object)servletContext.getContextPath())) {
                SpringBootProcessApplication.this.contextPath = servletContext.getContextPath();
            }
        }
    }
}

