/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.spring.boot.starter.configuration.impl;

import java.util.Optional;
import org.cibseven.bpm.engine.impl.cfg.IdGenerator;
import org.cibseven.bpm.engine.spring.SpringProcessEngineConfiguration;
import org.cibseven.bpm.spring.boot.starter.configuration.CamundaProcessEngineConfiguration;
import org.cibseven.bpm.spring.boot.starter.configuration.impl.AbstractCamundaConfiguration;
import org.cibseven.bpm.spring.boot.starter.property.CamundaBpmProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class DefaultProcessEngineConfiguration
extends AbstractCamundaConfiguration
implements CamundaProcessEngineConfiguration {
    @Autowired
    private Optional<IdGenerator> idGenerator;

    @Override
    public void preInit(SpringProcessEngineConfiguration configuration) {
        this.setProcessEngineName(configuration);
        this.setDefaultSerializationFormat(configuration);
        this.setIdGenerator(configuration);
        this.setJobExecutorAcquireByPriority(configuration);
        this.setDefaultNumberOfRetries(configuration);
    }

    private void setIdGenerator(SpringProcessEngineConfiguration configuration) {
        this.idGenerator.ifPresent(arg_0 -> ((SpringProcessEngineConfiguration)configuration).setIdGenerator(arg_0));
    }

    private void setDefaultSerializationFormat(SpringProcessEngineConfiguration configuration) {
        String defaultSerializationFormat = this.camundaBpmProperties.getDefaultSerializationFormat();
        if (StringUtils.hasText((String)defaultSerializationFormat)) {
            configuration.setDefaultSerializationFormat(defaultSerializationFormat);
        } else {
            this.logger.warn("Ignoring invalid defaultSerializationFormat='{}'", (Object)defaultSerializationFormat);
        }
    }

    private void setProcessEngineName(SpringProcessEngineConfiguration configuration) {
        String processEngineName = StringUtils.trimAllWhitespace((String)this.camundaBpmProperties.getProcessEngineName());
        if (!StringUtils.isEmpty((Object)processEngineName) && !processEngineName.contains("-")) {
            if (this.camundaBpmProperties.getGenerateUniqueProcessEngineName().booleanValue()) {
                if (!processEngineName.equals("default")) {
                    throw new RuntimeException(String.format("A unique processEngineName cannot be generated if a custom processEngineName is already set: %s", processEngineName));
                }
                processEngineName = CamundaBpmProperties.getUniqueName("processEngine");
            }
            configuration.setProcessEngineName(processEngineName);
        } else {
            this.logger.warn("Ignoring invalid processEngineName='{}' - must not be null, blank or contain hyphen", (Object)this.camundaBpmProperties.getProcessEngineName());
        }
    }

    private void setJobExecutorAcquireByPriority(SpringProcessEngineConfiguration configuration) {
        Optional.ofNullable(this.camundaBpmProperties.getJobExecutorAcquireByPriority()).ifPresent(arg_0 -> ((SpringProcessEngineConfiguration)configuration).setJobExecutorAcquireByPriority(arg_0));
    }

    private void setDefaultNumberOfRetries(SpringProcessEngineConfiguration configuration) {
        Optional.ofNullable(this.camundaBpmProperties.getDefaultNumberOfRetries()).ifPresent(arg_0 -> ((SpringProcessEngineConfiguration)configuration).setDefaultNumberOfRetries(arg_0));
    }
}

