/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.spring.boot.starter.property;

import java.util.Arrays;
import java.util.List;
import org.cibseven.bpm.spring.boot.starter.property.CamundaBpmProperties;
import org.cibseven.bpm.spring.boot.starter.property.Defaults;
import org.springframework.util.Assert;

public class DatabaseProperty {
    public static final List<String> SCHEMA_UPDATE_VALUES = Arrays.asList("true", "false", "create", "create-drop", "drop-create");
    private String schemaUpdate = "true";
    private String type;
    private String tablePrefix = Defaults.INSTANCE.getDatabaseTablePrefix();
    private String schemaName = Defaults.INSTANCE.getDatabaseSchema();
    private boolean jdbcBatchProcessing = true;

    public String getSchemaUpdate() {
        return this.schemaUpdate;
    }

    public void setSchemaUpdate(String schemaUpdate) {
        Assert.isTrue((boolean)SCHEMA_UPDATE_VALUES.contains(schemaUpdate), (String)String.format("schemaUpdate: '%s' is not valid (%s)", schemaUpdate, SCHEMA_UPDATE_VALUES));
        this.schemaUpdate = schemaUpdate;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public static List<String> getSchemaUpdateValues() {
        return SCHEMA_UPDATE_VALUES;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public boolean isJdbcBatchProcessing() {
        return this.jdbcBatchProcessing;
    }

    public void setJdbcBatchProcessing(boolean jdbcBatchProcessing) {
        this.jdbcBatchProcessing = jdbcBatchProcessing;
    }

    public String toString() {
        return CamundaBpmProperties.joinOn(this.getClass()).add("type=" + this.type).add("schemaUpdate=" + this.schemaUpdate).add("schemaName=" + this.schemaName).add("tablePrefix=" + this.tablePrefix).add("jdbcBatchProcessing=" + this.jdbcBatchProcessing).toString();
    }
}

