/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.webapp.impl.security.auth;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import org.cibseven.bpm.webapp.impl.IllegalWebAppConfigurationException;
import org.cibseven.bpm.webapp.impl.security.SecurityActions;
import org.cibseven.bpm.webapp.impl.security.auth.AuthenticationUtil;
import org.cibseven.bpm.webapp.impl.security.auth.Authentications;
import org.cibseven.bpm.webapp.impl.util.ServletContextUtil;
import org.cibseven.bpm.webapp.impl.util.ServletFilterUtil;

public class AuthenticationFilter
implements Filter {
    public static final String AUTH_CACHE_TTL_INIT_PARAM_NAME = "cacheTimeToLive";
    protected Long cacheTimeToLive = null;

    public void init(FilterConfig filterConfig) throws ServletException {
        String authCacheTTLAsString = filterConfig.getInitParameter(AUTH_CACHE_TTL_INIT_PARAM_NAME);
        if (!ServletFilterUtil.isEmpty(authCacheTTLAsString)) {
            this.cacheTimeToLive = Long.parseLong(authCacheTTLAsString.trim());
            if (this.cacheTimeToLive < 0L) {
                throw new IllegalWebAppConfigurationException("'cacheTimeToLive' cannot be negative.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpSession session = req.getSession(true);
        Authentications authentications = AuthenticationUtil.getAuthsFromSession(session);
        if (this.cacheTimeToLive != null) {
            if (this.cacheTimeToLive > 0L) {
                ServletContext servletContext = request.getServletContext();
                ServletContextUtil.setCacheTTLForLogin(this.cacheTimeToLive, servletContext);
            }
            AuthenticationUtil.updateCache(authentications, session, this.cacheTimeToLive);
        }
        Authentications.setCurrent(authentications);
        try {
            SecurityActions.runWithAuthentications(() -> {
                chain.doFilter(request, response);
                return null;
            }, authentications);
        }
        finally {
            Authentications.clearCurrent();
            AuthenticationUtil.updateSession(req.getSession(false), authentications);
        }
    }

    public void destroy() {
    }

    public Long getCacheTimeToLive() {
        return this.cacheTimeToLive;
    }
}

