/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.webapp.impl.security.filter;

import java.util.Map;
import org.cibseven.bpm.cockpit.Cockpit;
import org.cibseven.bpm.engine.ProcessEngine;
import org.cibseven.bpm.webapp.impl.security.auth.Authentication;
import org.cibseven.bpm.webapp.impl.security.auth.Authentications;
import org.cibseven.bpm.webapp.impl.security.auth.UserAuthentication;
import org.cibseven.bpm.webapp.impl.security.filter.Authorization;
import org.cibseven.bpm.webapp.impl.security.filter.RequestAuthorizer;

public class ApplicationRequestAuthorizer
implements RequestAuthorizer {
    @Override
    public Authorization authorize(Map<String, String> parameters) {
        Authentications authentications = Authentications.getCurrent();
        if (authentications == null) {
            return this.grantAnnonymous();
        }
        String engineName = parameters.get("engine");
        String appName = parameters.get("app");
        Authentication engineAuth = authentications.getAuthenticationForProcessEngine(engineName);
        if (engineAuth == null) {
            return this.grantAnnonymous();
        }
        ProcessEngine processEngine = Cockpit.getProcessEngine(engineName);
        if (processEngine == null) {
            return this.grantAnnonymous();
        }
        if (engineAuth instanceof UserAuthentication) {
            UserAuthentication userAuth = (UserAuthentication)engineAuth;
            if (userAuth.isAuthorizedForApp(appName)) {
                return Authorization.granted(userAuth).forApplication(appName);
            }
            return Authorization.denied(userAuth).forApplication(appName);
        }
        return Authorization.denied(Authentication.ANONYMOUS);
    }

    private Authorization grantAnnonymous() {
        return Authorization.granted(Authentication.ANONYMOUS);
    }
}

