/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.webapp.impl.security.filter;

import jakarta.servlet.FilterConfig;
import java.util.Arrays;
import org.cibseven.bpm.engine.ProcessEngineException;
import org.cibseven.bpm.webapp.impl.security.filter.util.CookieConstants;
import org.cibseven.bpm.webapp.impl.util.ServletFilterUtil;

public class CookieConfigurator {
    protected static final String ENABLE_SECURE_PARAM = "enableSecureCookie";
    protected static final String ENABLE_SAME_SITE_PARAM = "enableSameSiteCookie";
    protected static final String SAME_SITE_OPTION_PARAM = "sameSiteCookieOption";
    protected static final String SAME_SITE_VALUE_PARAM = "sameSiteCookieValue";
    protected boolean isSecureCookieEnabled;
    protected boolean isSameSiteCookieEnabled;
    protected String sameSiteCookieValue;
    protected String cookieName;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parseParams(FilterConfig filterConfig) {
        String enableSameSiteCookie;
        String cookieNameInput;
        String enableSecureCookie = filterConfig.getInitParameter(ENABLE_SECURE_PARAM);
        if (!ServletFilterUtil.isEmpty(enableSecureCookie)) {
            this.isSecureCookieEnabled = Boolean.parseBoolean(enableSecureCookie);
        }
        if (!this.isBlank(cookieNameInput = filterConfig.getInitParameter("cookieName"))) {
            this.cookieName = cookieNameInput;
        }
        this.isSameSiteCookieEnabled = !ServletFilterUtil.isEmpty(enableSameSiteCookie = filterConfig.getInitParameter(ENABLE_SAME_SITE_PARAM)) ? Boolean.parseBoolean(enableSameSiteCookie) : true;
        String sameSiteCookieValue = filterConfig.getInitParameter(SAME_SITE_VALUE_PARAM);
        String sameSiteCookieOption = filterConfig.getInitParameter(SAME_SITE_OPTION_PARAM);
        if (!ServletFilterUtil.isEmpty(sameSiteCookieValue) && !ServletFilterUtil.isEmpty(sameSiteCookieOption)) {
            throw new ProcessEngineException("Please either configure sameSiteCookieOption or sameSiteCookieValue.");
        }
        if (!ServletFilterUtil.isEmpty(sameSiteCookieValue)) {
            this.sameSiteCookieValue = sameSiteCookieValue;
            return;
        } else if (!ServletFilterUtil.isEmpty(sameSiteCookieOption)) {
            if (SameSiteOption.LAX.compareTo(sameSiteCookieOption)) {
                this.sameSiteCookieValue = SameSiteOption.LAX.getValue();
                return;
            } else {
                if (!SameSiteOption.STRICT.compareTo(sameSiteCookieOption)) throw new ProcessEngineException("For sameSiteCookieOption param, please configure one of the following options: " + Arrays.toString((Object[])SameSiteOption.values()));
                this.sameSiteCookieValue = SameSiteOption.STRICT.getValue();
            }
            return;
        } else {
            this.sameSiteCookieValue = SameSiteOption.LAX.getValue();
        }
    }

    public String getConfig() {
        return this.getConfig(null);
    }

    public String getConfig(String currentHeader) {
        StringBuilder stringBuilder = new StringBuilder(currentHeader == null ? "" : currentHeader);
        if (this.isSameSiteCookieEnabled && (currentHeader == null || !CookieConstants.SAME_SITE_FIELD_NAME_REGEX.matcher(currentHeader).find())) {
            stringBuilder.append(";SameSite=").append(this.sameSiteCookieValue);
        }
        if (this.isSecureCookieEnabled && (currentHeader == null || !CookieConstants.SECURE_FLAG_NAME_REGEX.matcher(currentHeader).find())) {
            stringBuilder.append(";Secure");
        }
        return stringBuilder.toString();
    }

    public String getCookieName(String defaultName) {
        return this.isBlank(this.cookieName) ? defaultName : this.cookieName;
    }

    protected boolean isBlank(String s) {
        return s == null || s.trim().isEmpty();
    }

    public static enum SameSiteOption {
        LAX("Lax"),
        STRICT("Strict");

        protected final String value;

        private SameSiteOption(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String getName() {
            return this.name();
        }

        public boolean compareTo(String value) {
            return this.value.equalsIgnoreCase(value);
        }
    }
}

